/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.CompoundDirectory;
import guideme.internal.shaded.lucene.codecs.FieldInfosFormat;
import guideme.internal.shaded.lucene.index.CodecReader;
import guideme.internal.shaded.lucene.index.DocValuesFieldUpdates;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.MergePolicy;
import guideme.internal.shaded.lucene.index.PendingDeletes;
import guideme.internal.shaded.lucene.index.SegmentCommitInfo;
import guideme.internal.shaded.lucene.index.SegmentInfo;
import guideme.internal.shaded.lucene.index.SegmentReader;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.FieldExistsQuery;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.IOSupplier;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.IOException;

final class PendingSoftDeletes
extends PendingDeletes {
    private final String field;
    private long dvGeneration = -2L;
    private final PendingDeletes hardDeletes;

    PendingSoftDeletes(String field, SegmentCommitInfo info) {
        super(info, null, info.getDelCount(true) == 0);
        this.field = field;
        this.hardDeletes = new PendingDeletes(info);
    }

    PendingSoftDeletes(String field, SegmentReader reader, SegmentCommitInfo info) {
        super(reader, info);
        this.field = field;
        this.hardDeletes = new PendingDeletes(reader, info);
    }

    @Override
    boolean delete(int docID) throws IOException {
        FixedBitSet mutableBits = this.getMutableBits();
        if (this.hardDeletes.delete(docID)) {
            if (mutableBits.getAndClear(docID)) {
                assert (!this.hardDeletes.delete(docID));
            } else {
                --this.pendingDeleteCount;
                assert (this.assertPendingDeletes());
            }
            return true;
        }
        return false;
    }

    @Override
    protected int numPendingDeletes() {
        return super.numPendingDeletes() + this.hardDeletes.numPendingDeletes();
    }

    @Override
    void onNewReader(CodecReader reader, SegmentCommitInfo info) throws IOException {
        super.onNewReader(reader, info);
        this.hardDeletes.onNewReader(reader, info);
        if (this.dvGeneration < info.getDocValuesGen()) {
            int newDelCount;
            DocIdSetIterator iterator = FieldExistsQuery.getDocValuesDocIdSetIterator(this.field, reader);
            if (iterator != null && iterator.nextDoc() != Integer.MAX_VALUE) {
                iterator = FieldExistsQuery.getDocValuesDocIdSetIterator(this.field, reader);
                newDelCount = PendingSoftDeletes.applySoftDeletes(iterator, this.getMutableBits());
                assert (newDelCount >= 0) : " illegal pending delete count: " + newDelCount;
            } else {
                newDelCount = 0;
            }
            assert (info.getSoftDelCount() == newDelCount) : "softDeleteCount doesn't match " + info.getSoftDelCount() + " != " + newDelCount;
            this.dvGeneration = info.getDocValuesGen();
        }
        assert (this.getDelCount() <= info.info.maxDoc()) : this.getDelCount() + " > " + info.info.maxDoc();
    }

    @Override
    boolean writeLiveDocs(Directory dir) throws IOException {
        this.info.setSoftDelCount(this.info.getSoftDelCount() + this.pendingDeleteCount);
        super.dropChanges();
        return this.hardDeletes.writeLiveDocs(dir);
    }

    @Override
    void dropChanges() {
        this.hardDeletes.dropChanges();
    }

    static int applySoftDeletes(DocIdSetIterator iterator, FixedBitSet bits) throws IOException {
        int docID;
        DocValuesFieldUpdates.Iterator hasValue;
        assert (iterator != null);
        int newDeletes = 0;
        DocValuesFieldUpdates.Iterator iterator2 = hasValue = iterator instanceof DocValuesFieldUpdates.Iterator ? (DocValuesFieldUpdates.Iterator)iterator : null;
        while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
            if (hasValue == null || hasValue.hasValue()) {
                if (!bits.getAndClear(docID)) continue;
                ++newDeletes;
                continue;
            }
            if (bits.getAndSet(docID)) continue;
            --newDeletes;
        }
        return newDeletes;
    }

    @Override
    void onDocValuesUpdate(FieldInfo info, DocValuesFieldUpdates.Iterator iterator) throws IOException {
        if (this.field.equals(info.name)) {
            this.pendingDeleteCount += PendingSoftDeletes.applySoftDeletes(iterator, this.getMutableBits());
            assert (this.assertPendingDeletes());
            this.info.setSoftDelCount(this.info.getSoftDelCount() + this.pendingDeleteCount);
            super.dropChanges();
        }
        assert (this.dvGeneration < info.getDocValuesGen()) : "we have seen this generation update already: " + this.dvGeneration + " vs. " + info.getDocValuesGen();
        assert (this.dvGeneration != -2L) : "docValues generation is still uninitialized";
        this.dvGeneration = info.getDocValuesGen();
    }

    private boolean assertPendingDeletes() {
        assert (this.pendingDeleteCount + this.info.getSoftDelCount() >= 0) : "illegal pending delete count: " + (this.pendingDeleteCount + this.info.getSoftDelCount());
        assert (this.info.info.maxDoc() >= this.getDelCount());
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PendingSoftDeletes(seg=").append(this.info);
        sb.append(" numPendingDeletes=").append(this.pendingDeleteCount);
        sb.append(" field=").append(this.field);
        sb.append(" dvGeneration=").append(this.dvGeneration);
        sb.append(" hardDeletes=").append(this.hardDeletes);
        return sb.toString();
    }

    @Override
    int numDeletesToMerge(MergePolicy policy, IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        this.ensureInitialized(readerIOSupplier);
        return super.numDeletesToMerge(policy, readerIOSupplier);
    }

    private void ensureInitialized(IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        if (this.dvGeneration == -2L) {
            FieldInfos fieldInfos = this.readFieldInfos();
            FieldInfo fieldInfo = fieldInfos.fieldInfo(this.field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                this.onNewReader(readerIOSupplier.get(), this.info);
            } else {
                this.dvGeneration = fieldInfo == null ? -1L : fieldInfo.getDocValuesGen();
            }
        }
    }

    @Override
    boolean isFullyDeleted(IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        this.ensureInitialized(readerIOSupplier);
        return super.isFullyDeleted(readerIOSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldInfos readFieldInfos() throws IOException {
        SegmentInfo segInfo = this.info.info;
        Directory dir = segInfo.dir;
        if (!this.info.hasFieldUpdates()) {
            FieldInfos fieldInfos;
            CompoundDirectory toClose;
            if (segInfo.getUseCompoundFile()) {
                dir = segInfo.getCodec().compoundFormat().getCompoundReader(segInfo.dir, segInfo);
                toClose = dir;
            } else {
                toClose = null;
                dir = segInfo.dir;
            }
            try {
                fieldInfos = segInfo.getCodec().fieldInfosFormat().read(dir, segInfo, "", IOContext.READONCE);
            }
            catch (Throwable throwable) {
                IOUtils.close(toClose);
                throw throwable;
            }
            IOUtils.close(toClose);
            return fieldInfos;
        }
        FieldInfosFormat fisFormat = segInfo.getCodec().fieldInfosFormat();
        String segmentSuffix = Long.toString(this.info.getFieldInfosGen(), 36);
        return fisFormat.read(dir, segInfo, segmentSuffix, IOContext.READONCE);
    }

    @Override
    Bits getHardLiveDocs() {
        return this.hardDeletes.getLiveDocs();
    }

    @Override
    boolean mustInitOnDelete() {
        return !this.liveDocsInitialized;
    }

    static int countSoftDeletes(DocIdSetIterator softDeletedDocs, Bits hardDeletes) throws IOException {
        int count = 0;
        if (softDeletedDocs != null) {
            int doc;
            while ((doc = softDeletedDocs.nextDoc()) != Integer.MAX_VALUE) {
                if (hardDeletes != null && !hardDeletes.get(doc)) continue;
                ++count;
            }
        }
        return count;
    }
}

