/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.builders;

import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.queryparser.flexible.core.QueryNodeException;
import guideme.internal.shaded.lucene.queryparser.flexible.core.builders.QueryTreeBuilder;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.QueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.SlopQueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import guideme.internal.shaded.lucene.search.MultiPhraseQuery;
import guideme.internal.shaded.lucene.search.PhraseQuery;
import guideme.internal.shaded.lucene.search.Query;

public class SlopQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public Query build(QueryNode queryNode) throws QueryNodeException {
        SlopQueryNode phraseSlopNode = (SlopQueryNode)queryNode;
        Query query = (Query)phraseSlopNode.getChild().getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
        if (query instanceof PhraseQuery) {
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(phraseSlopNode.getValue());
            PhraseQuery pq = (PhraseQuery)query;
            Term[] terms = pq.getTerms();
            int[] positions = pq.getPositions();
            for (int i = 0; i < terms.length; ++i) {
                builder.add(terms[i], positions[i]);
            }
            query = builder.build();
        } else {
            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
            int slop = phraseSlopNode.getValue();
            if (slop != mpq.getSlop()) {
                query = new MultiPhraseQuery.Builder(mpq).setSlop(slop).build();
            }
        }
        return query;
    }
}

