/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.annotation;

import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.scene.GuidebookScene;
import guideme.scene.annotation.AnnotationTagCompiler;
import guideme.scene.annotation.InWorldBoxAnnotation;
import guideme.scene.annotation.SceneAnnotation;
import java.util.Set;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BoxAnnotationElementCompiler
extends AnnotationTagCompiler {
    public static final String TAG_NAME = "BoxAnnotation";

    @Override
    public Set<String> getTagNames() {
        return Set.of(TAG_NAME);
    }

    @Override
    @Nullable
    protected SceneAnnotation createAnnotation(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        return this.createAnnotation(null, compiler, errorSink, el, BlockPos.ZERO);
    }

    @Override
    @Nullable
    protected SceneAnnotation createAnnotation(GuidebookScene scene, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, BlockPos instancePosition) {
        Vector3f min = MdxAttrs.getVector3(compiler, errorSink, el, "min", (Vector3fc)new Vector3f());
        Vector3f max = MdxAttrs.getVector3(compiler, errorSink, el, "max", (Vector3fc)new Vector3f());
        this.ensureMinMax(min, max);
        ColorValue color = MdxAttrs.getColor(compiler, errorSink, el, "color", ConstantColor.WHITE);
        float thickness = MdxAttrs.getFloat(compiler, errorSink, el, "thickness", 0.03125f);
        boolean alwaysOnTop = MdxAttrs.getBoolean(compiler, errorSink, el, "alwaysOnTop", false);
        min.add((float)instancePosition.getX(), (float)instancePosition.getY(), (float)instancePosition.getZ());
        max.add((float)instancePosition.getX(), (float)instancePosition.getY(), (float)instancePosition.getZ());
        InWorldBoxAnnotation annotation = new InWorldBoxAnnotation(min, max, color, thickness);
        annotation.setAlwaysOnTop(alwaysOnTop);
        return annotation;
    }

    private void ensureMinMax(Vector3f min, Vector3f max) {
        for (int i = 0; i < 3; ++i) {
            float maxVal;
            float minVal = min.get(i);
            if (!(minVal > (maxVal = max.get(i)))) continue;
            min.setComponent(i, maxVal);
            max.setComponent(i, minVal);
        }
    }
}

