/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.schematic;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.data.Constants;
import com.natamus.collective_common_neoforge.schematic.SchematicBlockObject;
import com.natamus.collective_common_neoforge.schematic.SchematicFunctions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Schematic {
    private int size;
    private short width;
    private short height;
    private short length;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private boolean oldVersion;
    private HashMap<Integer, String> palette;
    private SchematicBlockObject[] blockObjects;
    private List<CompoundTag> blockEntities;
    private List<Pair<BlockPos, CompoundTag>> entities;
    private boolean parsedCorrectly = false;

    public Schematic(InputStream inputStream) {
        new Schematic(inputStream, null);
    }

    public Schematic(InputStream inputStream, Level level) {
        DefaultedRegistry blockRegistry = BuiltInRegistries.BLOCK;
        if (level != null) {
            blockRegistry = level.registryAccess().registryOrThrow(Registries.BLOCK);
        }
        String type = "";
        try {
            CompoundTag nbtdata = SchematicFunctions.readCompressed(inputStream);
            inputStream.close();
            if (nbtdata.contains("Schematic")) {
                nbtdata = nbtdata.getCompound("Schematic");
            }
            if (nbtdata.contains("Length")) {
                this.width = nbtdata.getShort("Width");
                this.height = nbtdata.getShort("Height");
                this.length = nbtdata.getShort("Length");
            } else {
                ListTag sizeList = nbtdata.getList("size", 3);
                this.width = (short)sizeList.getInt(0);
                this.height = (short)sizeList.getInt(1);
                this.length = (short)sizeList.getInt(2);
            }
            this.size = this.width * this.height * this.length;
            type = nbtdata.contains("entities") ? "nbt" : (nbtdata.contains("DataVersion") ? "schem" : "schematic");
            this.blockObjects = new SchematicBlockObject[this.size];
            this.entities = new ArrayList<Pair<BlockPos, CompoundTag>>();
            switch (type) {
                case "schem": {
                    ListTag tileentitynbtlist;
                    CompoundTag palette;
                    byte[] blockDataRaw;
                    int[] blockData = new int[this.width * this.height * this.length];
                    if (nbtdata.getInt("Version") == 2) {
                        blockDataRaw = nbtdata.getByteArray("BlockData");
                        palette = nbtdata.getCompound("Palette");
                        tileentitynbtlist = nbtdata.getList("BlockEntities", 10);
                        CompoundTag offsetCompoundTag = nbtdata.getCompound("Metadata");
                        this.offsetX = offsetCompoundTag.getInt("WEOffsetX");
                        this.offsetY = offsetCompoundTag.getInt("WEOffsetY");
                        this.offsetZ = offsetCompoundTag.getInt("WEOffsetZ");
                    } else {
                        CompoundTag blocksCompoundTag = nbtdata.getCompound("Blocks");
                        blockDataRaw = blocksCompoundTag.getByteArray("Data");
                        palette = blocksCompoundTag.getCompound("Palette");
                        tileentitynbtlist = blocksCompoundTag.getList("BlockEntities", 10);
                        int[] offsetArray = nbtdata.getIntArray("Offset");
                        this.offsetX = offsetArray[0];
                        this.offsetY = offsetArray[1];
                        this.offsetZ = offsetArray[2];
                    }
                    int index = 0;
                    int i = 0;
                    while (i < blockDataRaw.length) {
                        int value = 0;
                        int varintLength = 0;
                        while (true) {
                            value |= (blockDataRaw[i] & 0x7F) << varintLength++ * 7;
                            if (varintLength > 5) continue;
                            if ((blockDataRaw[i] & 0x80) != 128) {
                                ++i;
                                break;
                            }
                            ++i;
                        }
                        blockData[index] = value;
                        ++index;
                    }
                    this.palette = new HashMap();
                    for (String k : palette.getAllKeys()) {
                        this.palette.put(palette.getInt(k), k);
                    }
                    int counter = 0;
                    for (int y = 0; y < this.height; ++y) {
                        for (int z = 0; z < this.length; ++z) {
                            for (int x = 0; x < this.width; ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                int id = blockData[counter];
                                if (id < 0) {
                                    id *= -1;
                                }
                                BlockState state = this.getStateFromID((Registry<Block>)blockRegistry, id);
                                this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                                ++counter;
                            }
                        }
                    }
                    this.blockEntities = new ArrayList<CompoundTag>();
                    for (int t = 0; t < tileentitynbtlist.size(); ++t) {
                        this.blockEntities.add(tileentitynbtlist.getCompound(t));
                    }
                    this.parsedCorrectly = true;
                    return;
                }
                case "schematic": {
                    byte[] blockIDs_byte = nbtdata.getByteArray("Blocks");
                    int[] blockIDs = new int[this.size];
                    for (int x = 0; x < blockIDs_byte.length; ++x) {
                        blockIDs[x] = Byte.toUnsignedInt(blockIDs_byte[x]);
                    }
                    byte[] metadata = nbtdata.getByteArray("Data");
                    int counter = 0;
                    for (int y = 0; y < this.height; ++y) {
                        for (int z = 0; z < this.length; ++z) {
                            for (int x = 0; x < this.width; ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                BlockState state = this.getStateFromOldIds(blockIDs[counter], metadata[counter]);
                                this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                                ++counter;
                            }
                        }
                    }
                    ListTag tileentitynbtlist = nbtdata.getList("TileEntities", 10);
                    this.blockEntities = new ArrayList<CompoundTag>();
                    for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                        CompoundTag compound = tileentitynbtlist.getCompound(i);
                        int i0 = compound.getInt("x");
                        int i1 = compound.getInt("y");
                        int i2 = compound.getInt("z");
                        compound.putIntArray("Pos", new int[]{i0, i1, i2});
                        this.blockEntities.add(compound);
                    }
                    this.offsetX = nbtdata.getInt("WEOffsetX");
                    this.offsetY = nbtdata.getInt("WEOffsetY");
                    this.offsetZ = nbtdata.getInt("WEOffsetZ");
                    this.parsedCorrectly = true;
                    return;
                }
                case "nbt": {
                    ListTag paletteNBTList = nbtdata.getList("palette", 10);
                    this.palette = new HashMap();
                    for (int i = 0; i < paletteNBTList.size(); ++i) {
                        CompoundTag compound = paletteNBTList.getCompound(i);
                        Object value = compound.getString("Name");
                        if (compound.contains("Properties")) {
                            StringBuilder metaData = new StringBuilder("[");
                            CompoundTag propertyCompound = compound.getCompound("Properties");
                            for (String propertyKey : propertyCompound.getAllKeys()) {
                                if (!metaData.toString().equals("[")) {
                                    metaData.append(",");
                                }
                                metaData.append(propertyKey).append("=").append(propertyCompound.get(propertyKey));
                            }
                            metaData.append("]");
                            value = (String)value + String.valueOf(metaData);
                        }
                        this.palette.put(i, (String)value);
                    }
                    this.blockEntities = new ArrayList<CompoundTag>();
                    ListTag blocksNBTList = nbtdata.getList("blocks", 10);
                    for (int i = 0; i < blocksNBTList.size(); ++i) {
                        CompoundTag compound = blocksNBTList.getCompound(i);
                        ListTag posList = compound.getList("pos", 3);
                        int i0 = posList.getInt(0);
                        int i1 = posList.getInt(1);
                        int i2 = posList.getInt(2);
                        BlockPos pos = new BlockPos(i0, i1, i2);
                        BlockState state = this.getStateFromID((Registry<Block>)blockRegistry, compound.getInt("state"));
                        this.blockObjects[i] = new SchematicBlockObject(pos, state);
                        if (!compound.contains("nbt")) continue;
                        CompoundTag blockEntityCompound = compound.getCompound("nbt");
                        blockEntityCompound.putIntArray("Pos", new int[]{i0, i1, i2});
                        blockEntityCompound.putString("Id", blockEntityCompound.getString("id"));
                        blockEntityCompound.remove("id");
                        this.blockEntities.add(blockEntityCompound);
                    }
                    ListTag entitiesNBTList = nbtdata.getList("entities", 10);
                    for (int i = 0; i < entitiesNBTList.size(); ++i) {
                        CompoundTag compound = entitiesNBTList.getCompound(i);
                        CompoundTag entityCompound = compound.getCompound("nbt");
                        ListTag posList = compound.getList("blockPos", 3);
                        int i0 = posList.getInt(0);
                        int i1 = posList.getInt(1);
                        int i2 = posList.getInt(2);
                        this.entities.add((Pair<BlockPos, CompoundTag>)new Pair((Object)new BlockPos(i0, i1, i2), (Object)entityCompound));
                    }
                    this.offsetX = 0;
                    this.offsetY = 0;
                    this.offsetZ = 0;
                    this.parsedCorrectly = true;
                    return;
                }
            }
        }
        catch (Exception ignored) {
            Constants.LOG.warn("[Collective] Something went wrong while parsing the schematic.");
        }
        Constants.LOG.warn("Can't load {} Schematic file.", (Object)type);
        this.width = 0;
        this.height = 0;
        this.length = 0;
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetZ = 0;
        this.size = 0;
        this.blockObjects = null;
        this.palette = null;
        this.blockEntities = null;
    }

    public boolean isOldVersion() {
        return this.oldVersion;
    }

    private BlockState getStateFromOldIds(int blockID, byte meta) {
        return Block.stateById((int)blockID);
    }

    public BlockState getBlockState(BlockPos pos) {
        for (SchematicBlockObject schematicBlockObject : this.blockObjects) {
            if (!schematicBlockObject.getPosition().equals((Object)pos)) continue;
            return schematicBlockObject.getState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public int getSize() {
        return this.size;
    }

    public SchematicBlockObject[] getBlocks() {
        return this.blockObjects;
    }

    public BlockState getStateFromID(Registry<Block> blockRegistry, int id) {
        String iblockstateS = this.palette.get(id);
        try {
            return BlockStateParser.parseForBlock((HolderLookup)blockRegistry.asLookup(), (StringReader)new StringReader(iblockstateS), (boolean)false).blockState();
        }
        catch (Exception ex) {
            return Blocks.AIR.defaultBlockState();
        }
    }

    public List<CompoundTag> getBlockEntities() {
        return this.blockEntities;
    }

    public List<Pair<BlockPos, CompoundTag>> getEntityRelativePosPairs() {
        return this.entities;
    }

    public CompoundTag getTileEntity(BlockPos pos) {
        for (CompoundTag compound : this.blockEntities) {
            int[] pos1 = compound.getIntArray("Pos");
            if (pos1[0] != pos.getX() || pos1[1] != pos.getY() || pos1[2] != pos.getZ()) continue;
            return compound;
        }
        return null;
    }

    public BlockPos getBlockPosFromCompoundTag(CompoundTag compoundTag) {
        int[] pos = compoundTag.getIntArray("Pos");
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public boolean wasParsedCorrectly() {
        return this.parsedCorrectly;
    }
}

