/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalUtils;

@NothingNullByDefault
public interface IChemicalHandler {
    public int getChemicalTanks();

    public ChemicalStack getChemicalInTank(int var1);

    public void setChemicalInTank(int var1, ChemicalStack var2);

    public long getChemicalTankCapacity(int var1);

    public boolean isValid(int var1, ChemicalStack var2);

    public ChemicalStack insertChemical(int var1, ChemicalStack var2, Action var3);

    public ChemicalStack extractChemical(int var1, long var2, Action var4);

    default public ChemicalStack insertChemical(ChemicalStack stack, Action action) {
        return ChemicalUtils.insert(stack, null, action, side -> this.getChemicalTanks(), (tank, side) -> this.getChemicalInTank(tank), (tank, chemical, s, act) -> this.insertChemical(tank, (ChemicalStack)chemical, act));
    }

    default public ChemicalStack extractChemical(long amount, Action action) {
        return ChemicalUtils.extract(amount, null, action, side -> this.getChemicalTanks(), (tank, side) -> this.getChemicalInTank(tank), (tank, amt, side, act) -> this.extractChemical(tank, amt, act));
    }

    default public ChemicalStack extractChemical(ChemicalStack stack, Action action) {
        return ChemicalUtils.extract(stack, null, action, side -> this.getChemicalTanks(), (tank, side) -> this.getChemicalInTank(tank), (tank, chemical, side, act) -> this.extractChemical(tank, chemical, act));
    }
}

