/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.basic.BasicRotaryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class RotaryRecipeBuilder
extends MekanismRecipeBuilder<RotaryRecipeBuilder> {
    @Nullable
    private final ChemicalStackIngredient chemicalInput;
    @Nullable
    private final FluidStackIngredient fluidInput;
    private final FluidStack fluidOutput;
    private final ChemicalStack chemicalOutput;

    protected RotaryRecipeBuilder(@Nullable FluidStackIngredient fluidInput, @Nullable ChemicalStackIngredient chemicalInput, ChemicalStack chemicalOutput, FluidStack fluidOutput) {
        this.chemicalInput = chemicalInput;
        this.fluidInput = fluidInput;
        this.chemicalOutput = chemicalOutput;
        this.fluidOutput = fluidOutput;
    }

    public static RotaryRecipeBuilder rotary(FluidStackIngredient fluidInput, ChemicalStack chemicalOutput) {
        if (chemicalOutput.isEmpty()) {
            throw new IllegalArgumentException("This rotary condensentrator recipe requires a non empty chemical output.");
        }
        return new RotaryRecipeBuilder(fluidInput, null, chemicalOutput, FluidStack.EMPTY);
    }

    public static RotaryRecipeBuilder rotary(ChemicalStackIngredient chemicalInput, FluidStack fluidOutput) {
        if (fluidOutput.isEmpty()) {
            throw new IllegalArgumentException("This rotary condensentrator recipe requires a non empty fluid output.");
        }
        return new RotaryRecipeBuilder(null, chemicalInput, ChemicalStack.EMPTY, fluidOutput);
    }

    public static RotaryRecipeBuilder rotary(FluidStackIngredient fluidInput, ChemicalStackIngredient chemicalInput, ChemicalStack chemicalOutput, FluidStack fluidOutput) {
        if (chemicalOutput.isEmpty() || fluidOutput.isEmpty()) {
            throw new IllegalArgumentException("This rotary condensentrator recipe requires non empty chemical and fluid outputs.");
        }
        return new RotaryRecipeBuilder(fluidInput, chemicalInput, chemicalOutput, fluidOutput);
    }

    protected RotaryRecipe asRecipe() {
        if (this.fluidInput != null) {
            if (this.chemicalInput != null) {
                return new BasicRotaryRecipe(this.fluidInput, this.chemicalInput, this.chemicalOutput, this.fluidOutput);
            }
            return new BasicRotaryRecipe(this.fluidInput, this.chemicalOutput);
        }
        if (this.chemicalInput != null) {
            return new BasicRotaryRecipe(this.chemicalInput, this.fluidOutput);
        }
        throw new IllegalStateException("Invalid rotary recipe");
    }
}

