/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.config.ModuleConfig;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public class ModuleColorConfig
extends ModuleConfig<Integer> {
    public static final Codec<ModuleColorConfig> ARGB_CODEC = RecordCodecBuilder.create(instance -> ModuleColorConfig.baseCodec(instance).and((App)Codec.INT.fieldOf("value").forGetter(ModuleConfig::get)).apply((Applicative)instance, ModuleColorConfig::argb));
    public static final StreamCodec<ByteBuf, ModuleColorConfig> ARGB_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ModuleConfig::name, (StreamCodec)ByteBufCodecs.INT, ModuleConfig::get, ModuleColorConfig::argb);
    public static final Codec<ModuleColorConfig> RGB_CODEC = RecordCodecBuilder.create(instance -> ModuleColorConfig.baseCodec(instance).and((App)Codec.INT.fieldOf("value").forGetter(ModuleConfig::get)).apply((Applicative)instance, ModuleColorConfig::rgb));
    public static final StreamCodec<ByteBuf, ModuleColorConfig> RGB_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ModuleConfig::name, (StreamCodec)ByteBufCodecs.VAR_INT, module -> module.get() & 0xFFFFFF, ModuleColorConfig::rgb);
    private final boolean supportsAlpha;
    private final int value;

    public static ModuleColorConfig argb(ResourceLocation name) {
        return ModuleColorConfig.argb(name, -1);
    }

    public static ModuleColorConfig argb(ResourceLocation name, int defaultColor) {
        return new ModuleColorConfig(name, true, defaultColor);
    }

    public static ModuleColorConfig rgb(ResourceLocation name) {
        return ModuleColorConfig.rgb(name, -1);
    }

    public static ModuleColorConfig rgb(ResourceLocation name, int defaultColor) {
        return new ModuleColorConfig(name, false, defaultColor);
    }

    private ModuleColorConfig(ResourceLocation name, boolean supportsAlpha, int value) {
        super(name);
        this.supportsAlpha = supportsAlpha;
        this.value = this.supportsAlpha ? value : value | 0xFF000000;
    }

    public boolean supportsAlpha() {
        return this.supportsAlpha;
    }

    @Override
    public StreamCodec<ByteBuf, ModuleConfig<Integer>> namedStreamCodec(ResourceLocation name) {
        if (this.supportsAlpha) {
            return ByteBufCodecs.INT.map(val -> ModuleColorConfig.argb(name, val), ModuleConfig::get);
        }
        return ByteBufCodecs.VAR_INT.map(val -> ModuleColorConfig.rgb(name, val), module -> (Integer)module.get() & 0xFFFFFF);
    }

    @Override
    public Integer get() {
        return this.value;
    }

    public ModuleColorConfig with(Integer value) {
        Objects.requireNonNull(value, "Value cannot be null.");
        int sanitizedValue = this.supportsAlpha ? value : value | 0xFF000000;
        return this.value == sanitizedValue ? this : new ModuleColorConfig(this.name(), this.supportsAlpha, sanitizedValue);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleColorConfig other = (ModuleColorConfig)o;
        return this.supportsAlpha == other.supportsAlpha && this.value == other.value;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.supportsAlpha);
        result = 31 * result + this.value;
        return result;
    }
}

