/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;

@NothingNullByDefault
public interface IChemicalStackIngredientCreator
extends IIngredientCreator<Chemical, ChemicalStack, ChemicalStackIngredient> {
    @Override
    default public ChemicalStackIngredient from(ChemicalStack instance) {
        Objects.requireNonNull(instance, "ChemicalStackIngredients cannot be created from a null ChemicalStack.");
        return this.fromHolder(instance.getChemicalHolder(), instance.getAmount());
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    default public ChemicalStackIngredient from(Chemical instance, int amount) {
        return this.fromHolder((Holder)instance.getAsHolder(), amount);
    }

    @Override
    default public ChemicalStackIngredient fromHolder(Holder<Chemical> instance, int amount) {
        return this.fromHolder(instance, (long)amount);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public ChemicalStackIngredient from(IChemicalProvider provider, long amount) {
        Objects.requireNonNull(provider, "ChemicalStackIngredients cannot be created from a null chemical provider.");
        return this.from(IngredientCreatorAccess.chemical().of(provider), amount);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public ChemicalStackIngredient from(int amount, Chemical ... chemicals) {
        return this.from((long)amount, (IChemicalProvider[])chemicals);
    }

    @Override
    default public ChemicalStackIngredient fromHolders(int amount, Holder<Chemical> ... holders) {
        return this.fromHolders((long)amount, holders);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public ChemicalStackIngredient from(long amount, IChemicalProvider ... chemicals) {
        if (chemicals.length == 0) {
            throw new IllegalArgumentException("Attempted to create a ChemicalStackIngredient with no chemicals.");
        }
        return this.from(IngredientCreatorAccess.chemical().of(chemicals), amount);
    }

    default public ChemicalStackIngredient fromHolder(Holder<Chemical> instance, long amount) {
        Objects.requireNonNull(instance, "ChemicalStackIngredients cannot be created from a null chemical provider.");
        return this.from(IngredientCreatorAccess.chemical().of(instance), amount);
    }

    default public ChemicalStackIngredient fromHolders(long amount, Holder<Chemical> ... chemicals) {
        if (chemicals.length == 0) {
            throw new IllegalArgumentException("Attempted to create a ChemicalStackIngredient with no chemicals.");
        }
        return this.from(IngredientCreatorAccess.chemical().ofHolders(chemicals), amount);
    }

    @Override
    default public ChemicalStackIngredient from(TagKey<Chemical> tag, int amount) {
        return this.from(tag, (long)amount);
    }

    default public ChemicalStackIngredient from(TagKey<Chemical> tag, long amount) {
        Objects.requireNonNull(tag, "ChemicalStackIngredients cannot be created from a null tag.");
        return this.from(IngredientCreatorAccess.chemical().tag(tag), amount);
    }

    public ChemicalStackIngredient from(ChemicalIngredient var1, long var2);
}

