/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collections;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.recipe.MekanismEmiHolderRecipe;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class PressurizedReactionEmiRecipe
extends MekanismEmiHolderRecipe<PressurizedReactionRecipe> {
    public PressurizedReactionEmiRecipe(MekanismEmiRecipeCategory category, RecipeHolder<PressurizedReactionRecipe> recipeHolder) {
        super(category, recipeHolder);
        this.addInputDefinition(((PressurizedReactionRecipe)this.recipe).getInputSolid());
        this.addInputDefinition(((PressurizedReactionRecipe)this.recipe).getInputFluid());
        this.addInputDefinition(((PressurizedReactionRecipe)this.recipe).getInputChemical());
        ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>();
        ArrayList<ChemicalStack> chemicalOutputs = new ArrayList<ChemicalStack>();
        for (PressurizedReactionRecipe.PressurizedReactionRecipeOutput output : ((PressurizedReactionRecipe)this.recipe).getOutputDefinition()) {
            itemOutputs.add(output.item());
            chemicalOutputs.add(output.chemical());
        }
        if (itemOutputs.stream().allMatch(ConstantPredicates.ITEM_EMPTY)) {
            this.addOutputDefinition(Collections.emptyList());
        } else {
            this.addItemOutputDefinition(itemOutputs);
        }
        if (chemicalOutputs.stream().allMatch(ConstantPredicates.CHEMICAL_EMPTY)) {
            this.addOutputDefinition(Collections.emptyList());
        } else {
            this.addChemicalOutputDefinition(chemicalOutputs);
        }
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        this.addSlot(widgetHolder, SlotType.INPUT, 54, 40, this.input(0));
        this.addSlot(widgetHolder, SlotType.OUTPUT, 116, 40, this.output(0)).recipeContext((EmiRecipe)this);
        this.addSlot(widgetHolder, SlotType.POWER, 141, 22).with(SlotOverlay.POWER);
        this.initTank(widgetHolder, GuiFluidGauge.getDummy(GaugeType.STANDARD.with(DataType.INPUT), this, 5, 15), this.input(1));
        GaugeType type1 = GaugeType.STANDARD.with(DataType.INPUT);
        this.initTank(widgetHolder, GuiChemicalGauge.getDummy(type1, this, 28, 15), this.input(2));
        GaugeType type = GaugeType.SMALL.with(DataType.OUTPUT);
        this.initTank(widgetHolder, GuiChemicalGauge.getDummy(type, this, 140, 45), this.output(1)).recipeContext((EmiRecipe)this);
        this.addElement(widgetHolder, new GuiVerticalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 164, 21));
        this.addSimpleProgress(widgetHolder, ProgressType.RIGHT, 77, 43, ((PressurizedReactionRecipe)this.recipe).getDuration());
    }
}

