/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.heat;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.common.attachments.containers.ComponentBackedContainer;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.heat.AttachedHeat;
import mekanism.common.attachments.containers.heat.HeatCapacitorData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public class ComponentBackedHeatCapacitor
extends ComponentBackedContainer<HeatCapacitorData, AttachedHeat>
implements IHeatCapacitor {
    private final double inverseConductionCoefficient;
    private final double inverseInsulationCoefficient;
    private final HeatCapacitorData defaultData;

    public ComponentBackedHeatCapacitor(ItemStack attachedTo, int slotIndex, double inverseConductionCoefficient, double inverseInsulationCoefficient) {
        this(attachedTo, slotIndex, inverseConductionCoefficient, inverseInsulationCoefficient, 1.0);
    }

    public ComponentBackedHeatCapacitor(ItemStack attachedTo, int slotIndex, double inverseConductionCoefficient, double inverseInsulationCoefficient, double defaultHeatCapacity) {
        super(attachedTo, slotIndex);
        this.inverseConductionCoefficient = inverseConductionCoefficient;
        this.inverseInsulationCoefficient = inverseInsulationCoefficient;
        this.defaultData = new HeatCapacitorData(defaultHeatCapacity);
    }

    @Override
    protected HeatCapacitorData copy(HeatCapacitorData toCopy) {
        return toCopy;
    }

    @Override
    protected boolean isEmpty(HeatCapacitorData value) {
        return value.equals(this.defaultData);
    }

    @Override
    protected ContainerType<?, AttachedHeat, ?> containerType() {
        return ContainerType.HEAT;
    }

    @Override
    protected HeatCapacitorData getContents(AttachedHeat attached) {
        if (this.containerIndex < 0 || this.containerIndex >= attached.size()) {
            return this.defaultData;
        }
        return (HeatCapacitorData)attached.get(this.containerIndex);
    }

    protected HeatCapacitorData getData() {
        return this.getContents((AttachedHeat)this.getAttached());
    }

    @Override
    public double getTemperature() {
        return this.getData().temperature();
    }

    @Override
    public double getInverseConduction() {
        return this.inverseConductionCoefficient;
    }

    @Override
    public double getInverseInsulation() {
        return this.inverseInsulationCoefficient;
    }

    @Override
    public double getHeatCapacity() {
        return this.getData().capacity();
    }

    @Override
    public double getHeat() {
        return this.getData().heatOrAmbient();
    }

    @Override
    public void setHeat(double heat) {
        AttachedHeat attachedHeat = (AttachedHeat)this.getAttached();
        this.setContents(attachedHeat, this.getContents(attachedHeat).withHeat(heat));
    }

    @Override
    protected boolean shouldUpdate(AttachedHeat attached, HeatCapacitorData value) {
        return !this.getContents(attached).equals(value);
    }

    @Override
    public void handleHeat(double transfer) {
        AttachedHeat attachedHeat;
        if (transfer != 0.0 && Math.abs(transfer) > (double)1.0E-6f && !(attachedHeat = (AttachedHeat)this.getAttached()).isEmpty()) {
            HeatCapacitorData stored = this.getContents(attachedHeat);
            this.setContents(attachedHeat, stored.withHeat(stored.heatOrAmbient() + transfer));
        }
    }

    @Override
    public boolean isAmbientTemperature() {
        return this.getData().heat().isEmpty();
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        HeatCapacitorData data = this.getData();
        if (data.heat().isPresent()) {
            nbt.putDouble("stored", data.heat().getAsDouble());
        }
        nbt.putDouble("heat_capacity", data.capacity());
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        double capacity = nbt.contains("heat_capacity", 6) ? nbt.getDouble("heat_capacity") : this.defaultData.capacity();
        HeatCapacitorData data = nbt.contains("stored", 6) ? new HeatCapacitorData(nbt.getDouble("stored"), capacity) : new HeatCapacitorData(capacity);
        this.setContents((AttachedHeat)this.getAttached(), data);
    }
}

