/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GearConfig
extends BaseMekanismConfig {
    public static final String FREE_RUNNER_CATEGORY = "free_runner";
    public static final String JETPACK_CATEGORY = "jetpack";
    public static final String MEKASUIT_CATEGORY = "mekasuit";
    public static final String MEKASUIT_DAMAGE_CATEGORY = "damage_absorption";
    private final ModConfigSpec configSpec;
    public final CachedLongValue disassemblerEnergyUsage;
    public final CachedLongValue disassemblerEnergyUsageWeapon;
    public final CachedIntValue disassemblerMiningCount;
    public final CachedBooleanValue disassemblerSlowMode;
    public final CachedBooleanValue disassemblerFastMode;
    public final CachedBooleanValue disassemblerVeinMining;
    public final CachedIntValue disassemblerMinDamage;
    public final CachedIntValue disassemblerMaxDamage;
    public final CachedDoubleValue disassemblerAttackSpeed;
    public final CachedLongValue disassemblerMaxEnergy;
    public final CachedLongValue disassemblerChargeRate;
    public final CachedLongValue electricBowMaxEnergy;
    public final CachedLongValue electricBowChargeRate;
    public final CachedLongValue electricBowEnergyUsage;
    public final CachedLongValue electricBowEnergyUsageFire;
    public final CachedLongValue tabletMaxEnergy;
    public final CachedLongValue tabletChargeRate;
    public final CachedIntValue gaugeDroppedTransferRate;
    public final CachedIntValue gaugeDropperCapacity;
    public final CachedLongValue flamethrowerCapacity;
    public final CachedLongValue flamethrowerFillRate;
    public final CachedBooleanValue flamethrowerDestroyItems;
    public final CachedLongValue freeRunnerFallEnergyCost;
    public final CachedFloatValue freeRunnerFallDamageRatio;
    public final CachedLongValue freeRunnerMaxEnergy;
    public final CachedLongValue freeRunnerChargeRate;
    public final CachedLongValue jetpackCapacity;
    public final CachedLongValue jetpackFillRate;
    public final CachedLongValue portableTeleporterMaxEnergy;
    public final CachedLongValue portableTeleporterChargeRate;
    public final CachedIntValue portableTeleporterDelay;
    public final CachedLongValue networkReaderMaxEnergy;
    public final CachedLongValue networkReaderChargeRate;
    public final CachedLongValue networkReaderEnergyUsage;
    public final CachedLongValue scubaTankCapacity;
    public final CachedLongValue scubaFillRate;
    public final CachedLongValue seismicReaderMaxEnergy;
    public final CachedLongValue seismicReaderChargeRate;
    public final CachedLongValue seismicReaderEnergyUsage;
    public final CachedIntValue canteenMaxStorage;
    public final CachedIntValue canteenTransferRate;
    public final CachedLongValue mekaToolEnergyUsageWeapon;
    public final CachedLongValue mekaToolEnergyUsageTeleport;
    public final CachedLongValue mekaToolEnergyUsage;
    public final CachedLongValue mekaToolEnergyUsageSilk;
    public final CachedIntValue mekaToolMaxTeleportReach;
    public final CachedIntValue mekaToolBaseDamage;
    public final CachedDoubleValue mekaToolAttackSpeed;
    public final CachedFloatValue mekaToolBaseEfficiency;
    public final CachedLongValue mekaToolBaseEnergyCapacity;
    public final CachedLongValue mekaToolBaseChargeRate;
    public final CachedLongValue mekaToolEnergyUsageHoe;
    public final CachedLongValue mekaToolEnergyUsageShovel;
    public final CachedLongValue mekaToolEnergyUsageAxe;
    public final CachedLongValue mekaToolEnergyUsageShearEntity;
    public final CachedLongValue mekaToolEnergyUsageShearTrim;
    public final CachedBooleanValue mekaToolExtendedMining;
    public final CachedLongValue mekaSuitBaseEnergyCapacity;
    public final CachedLongValue mekaSuitBaseChargeRate;
    public final CachedLongValue mekaSuitBaseJumpEnergyUsage;
    public final CachedLongValue mekaSuitElytraEnergyUsage;
    public final CachedLongValue mekaSuitEnergyUsagePotionTick;
    public final CachedLongValue mekaSuitEnergyUsageMagicReduce;
    public final CachedLongValue mekaSuitEnergyUsageFall;
    public final CachedLongValue mekaSuitEnergyUsageSprintBoost;
    public final CachedLongValue mekaSuitEnergyUsageGravitationalModulation;
    public final CachedLongValue mekaSuitInventoryChargeRate;
    public final CachedLongValue mekaSuitSolarRechargingRate;
    public final CachedLongValue mekaSuitEnergyUsageVisionEnhancement;
    public final CachedLongValue mekaSuitEnergyUsageHydrostaticRepulsion;
    public final CachedLongValue mekaSuitEnergyUsageNutritionalInjection;
    public final CachedLongValue mekaSuitEnergyUsageDamage;
    public final CachedLongValue mekaSuitEnergyUsageItemAttraction;
    public final CachedBooleanValue mekaSuitGravitationalVibrations;
    public final CachedIntValue mekaSuitNutritionalMaxStorage;
    public final CachedIntValue mekaSuitNutritionalTransferRate;
    public final CachedLongValue mekaSuitJetpackMaxStorage;
    public final CachedLongValue mekaSuitJetpackTransferRate;
    public final CachedFloatValue mekaSuitFallDamageRatio;
    public final CachedFloatValue mekaSuitMagicDamageRatio;
    public final CachedFloatValue mekaSuitUnspecifiedDamageRatio;

    GearConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        MekanismConfigTranslations.GEAR_DISASSEMBLER.applyToBuilder(builder).push("atomic_disassembler");
        this.disassemblerMaxEnergy = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_DISASSEMBLER_MAX_ENERGY, "maxEnergy", 1000000L);
        this.disassemblerChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_DISASSEMBLER_CHARGE_RATE, "chargeRate", 5000L);
        this.disassemblerEnergyUsage = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_DISASSEMBLER_ENERGY_USAGE, "energyUsage", 10L);
        this.disassemblerEnergyUsageWeapon = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_DISASSEMBLER_ENERGY_USAGE_WEAPON, "energyUsageWeapon", 2000L);
        this.disassemblerMinDamage = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_DISASSEMBLER_MIN_DAMAGE.applyToBuilder(builder).defineInRange("minDamage", 4, 0, 1000));
        this.disassemblerMaxDamage = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_DISASSEMBLER_MAX_DAMAGE.applyToBuilder(builder).defineInRange("maxDamage", 20, 1, 10000));
        this.disassemblerAttackSpeed = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GEAR_DISASSEMBLER_ATTACK_SPEED.applyToBuilder(builder).defineInRange("attackSpeed", -2.4, -((Attribute)Attributes.ATTACK_SPEED.value()).getDefaultValue(), 100.0));
        this.disassemblerSlowMode = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GEAR_DISASSEMBLER_SLOW.applyToBuilder(builder).define("slowMode", true));
        this.disassemblerFastMode = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GEAR_DISASSEMBLER_FAST.applyToBuilder(builder).define("fastMode", true));
        this.disassemblerVeinMining = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GEAR_DISASSEMBLER_VEIN_MINING.applyToBuilder(builder).define("veinMining", false));
        this.disassemblerMiningCount = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_DISASSEMBLER_MINING_COUNT.applyToBuilder(builder).defineInRange("miningCount", 128, 2, 1000000));
        builder.pop();
        MekanismConfigTranslations.GEAR_BOW.applyToBuilder(builder).push("electric_bow");
        this.electricBowMaxEnergy = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_BOW_MAX_ENERGY, "maxEnergy", 120000L);
        this.electricBowChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_BOW_CHARGE_RATE, "chargeRate", 600L);
        this.electricBowEnergyUsage = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_BOW_ENERGY_USAGE, "energyUsage", 120L);
        this.electricBowEnergyUsageFire = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_BOW_ENERGY_USAGE_FLAME, "energyUsageFlame", 1200L);
        builder.pop();
        MekanismConfigTranslations.GEAR_ENERGY_TABLET.applyToBuilder(builder).push("energy_tablet");
        this.tabletMaxEnergy = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_ENERGY_TABLET_MAX_ENERGY, "maxEnergy", 1000000L);
        this.tabletChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_ENERGY_TABLET_CHARGE_RATE, "chargeRate", 5000L);
        builder.pop();
        MekanismConfigTranslations.GEAR_GAUGE_DROPPER.applyToBuilder(builder).push("gauge_dropper");
        this.gaugeDropperCapacity = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_GAUGE_DROPPER_CAPACITY.applyToBuilder(builder).defineInRange("capacity", 16000, 1, Integer.MAX_VALUE));
        this.gaugeDroppedTransferRate = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_GAUGE_DROPPER_TRANSFER_RATE.applyToBuilder(builder).defineInRange("transferRate", 250, 1, Integer.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GEAR_FLAMETHROWER.applyToBuilder(builder).push("flamethrower");
        this.flamethrowerCapacity = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GEAR_FLAMETHROWER_CAPACITY.applyToBuilder(builder).defineInRange("capacity", 24000L, 1L, Long.MAX_VALUE));
        this.flamethrowerFillRate = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GEAR_FLAMETHROWER_FILL_RATE.applyToBuilder(builder).defineInRange("fillRate", 16L, 1L, Long.MAX_VALUE));
        this.flamethrowerDestroyItems = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GEAR_FLAMETHROWER_DESTROY_ITEMS.applyToBuilder(builder).define("destroyItems", true));
        builder.pop();
        MekanismConfigTranslations.GEAR_FREE_RUNNERS.applyToBuilder(builder).push(FREE_RUNNER_CATEGORY);
        this.freeRunnerMaxEnergy = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_FREE_RUNNERS_MAX_ENERGY, "maxEnergy", 64000L);
        this.freeRunnerChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_FREE_RUNNERS_CHARGE_RATE, "chargeRate", 320L);
        this.freeRunnerFallEnergyCost = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_FREE_RUNNERS_FALL_COST, "fallEnergyCost", 50L);
        this.freeRunnerFallDamageRatio = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GEAR_FREE_RUNNERS_FALL_DAMAGE.applyToBuilder(builder).defineInRange("fallDamageReductionRatio", 1.0, 0.0, 1.0));
        builder.pop();
        MekanismConfigTranslations.GEAR_JETPACK.applyToBuilder(builder).push(JETPACK_CATEGORY);
        this.jetpackCapacity = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GEAR_JETPACK_CAPACITY.applyToBuilder(builder).defineInRange("capacity", 24000L, 1L, Long.MAX_VALUE));
        this.jetpackFillRate = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GEAR_JETPACK_FILL_RATE.applyToBuilder(builder).defineInRange("fillRate", 16L, 1L, Long.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GEAR_NETWORK_READER.applyToBuilder(builder).push("network_reader");
        this.networkReaderMaxEnergy = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_NETWORK_READER_MAX_ENERGY, "maxEnergy", 60000L);
        this.networkReaderChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_NETWORK_READER_CHARGE_RATE, "chargeRate", 300L);
        this.networkReaderEnergyUsage = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_NETWORK_READER_ENERGY_USAGE, "energyUsage", 400L);
        builder.pop();
        MekanismConfigTranslations.GEAR_PORTABLE_TELEPORTER.applyToBuilder(builder).push("portable_teleporter");
        this.portableTeleporterMaxEnergy = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_PORTABLE_TELEPORTER_MAX_ENERGY, "maxEnergy", 1000000L);
        this.portableTeleporterChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_PORTABLE_TELEPORTER_CHARGE_RATE, "chargeRate", 5000L);
        this.portableTeleporterDelay = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_PORTABLE_TELEPORTER_DELAY.applyToBuilder(builder).defineInRange("delay", 0, 0, 6000));
        builder.pop();
        MekanismConfigTranslations.GEAR_SCUBA_TANK.applyToBuilder(builder).push("scuba_tank");
        this.scubaTankCapacity = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GEAR_SCUBA_TANK_CAPACITY.applyToBuilder(builder).defineInRange("capacity", 24000L, 1L, Long.MAX_VALUE));
        this.scubaFillRate = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GEAR_SCUBA_TANK_FILL_RATE.applyToBuilder(builder).defineInRange("fillRate", 16L, 1L, Long.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GEAR_SEISMIC_READER.applyToBuilder(builder).push("seismic_reader");
        this.seismicReaderMaxEnergy = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_SEISMIC_READER_MAX_ENERGY, "maxEnergy", 12000L);
        this.seismicReaderChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_SEISMIC_READER_CHARGE_RATE, "chargeRate", 60L);
        this.seismicReaderEnergyUsage = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_SEISMIC_READER_ENERGY_USAGE, "energyUsage", 250L);
        builder.pop();
        MekanismConfigTranslations.GEAR_CANTEEN.applyToBuilder(builder).push("canteen");
        this.canteenMaxStorage = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_CANTEEN_CAPACITY.applyToBuilder(builder).defineInRange("maxStorage", 64000, 1, Integer.MAX_VALUE));
        this.canteenTransferRate = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_CANTEEN_TRANSFER_RATE.applyToBuilder(builder).defineInRange("transferRate", 128, 1, Integer.MAX_VALUE));
        builder.pop();
        MekanismConfigTranslations.GEAR_MEKA_TOOL.applyToBuilder(builder).push("mekatool");
        this.mekaToolBaseEnergyCapacity = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_CAPACITY, "baseEnergyCapacity", 16000000L);
        this.mekaToolBaseChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_CHARGE_RATE, "chargeRate", 100000L);
        this.mekaToolBaseDamage = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_MEKA_TOOL_DAMAGE.applyToBuilder(builder).defineInRange("baseDamage", 4, 0, 100000));
        this.mekaToolAttackSpeed = CachedDoubleValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GEAR_MEKA_TOOL_ATTACK_SPEED.applyToBuilder(builder).defineInRange("attackSpeed", -2.4, -((Attribute)Attributes.ATTACK_SPEED.value()).getDefaultValue(), 100.0));
        this.mekaToolBaseEfficiency = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GEAR_MEKA_TOOL_EFFICIENCY.applyToBuilder(builder).defineInRange("baseEfficiency", 4.0, 0.1, 100.0));
        this.mekaToolExtendedMining = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GEAR_MEKA_TOOL_EXTENDED_VEIN.applyToBuilder(builder).define("extendedMining", true));
        this.mekaToolMaxTeleportReach = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_MEKA_TOOL_TELEPORTATION_DISTANCE.applyToBuilder(builder).defineInRange("maxTeleportReach", 100, 3, 1024));
        MekanismConfigTranslations.GEAR_MEKA_TOOL_ENERGY_USAGE.applyToBuilder(builder).push("energy_usage");
        this.mekaToolEnergyUsage = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_ENERGY_USAGE_BASE, "base", 10L);
        this.mekaToolEnergyUsageSilk = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_ENERGY_USAGE_SILK, "silk", 100L);
        this.mekaToolEnergyUsageWeapon = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_ENERGY_USAGE_WEAPON, "weapon", 2000L);
        this.mekaToolEnergyUsageHoe = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_HOE, "hoe", 10L);
        this.mekaToolEnergyUsageShovel = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_SHOVEL, "shovel", 10L);
        this.mekaToolEnergyUsageAxe = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_AXE, "axe", 10L);
        this.mekaToolEnergyUsageShearEntity = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_SHEAR_ENTITY, "shearEntity", 10L);
        this.mekaToolEnergyUsageShearTrim = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_SHEAR_BLOCK, "shearTrim", 10L);
        this.mekaToolEnergyUsageTeleport = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_TOOL_ENERGY_USAGE_TELEPORT, "teleport", 1000L);
        builder.pop(2);
        MekanismConfigTranslations.GEAR_MEKA_SUIT.applyToBuilder(builder).push(MEKASUIT_CATEGORY);
        this.mekaSuitBaseEnergyCapacity = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_CAPACITY, "baseEnergyCapacity", 16000000L);
        this.mekaSuitBaseChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_CHARGE_RATE, "chargeRate", 100000L);
        this.mekaSuitInventoryChargeRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_CHARGE_RATE_INVENTORY, "inventoryChargeRate", 10000L);
        this.mekaSuitSolarRechargingRate = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_CHARGE_RATE_SOLAR, "solarRechargingRate", 500L);
        this.mekaSuitGravitationalVibrations = CachedBooleanValue.wrap(this, (ModConfigSpec.ConfigValue<Boolean>)MekanismConfigTranslations.GEAR_MEKA_SUIT_FLIGHT_VIBRATIONS.applyToBuilder(builder).define("gravitationalVibrations", true));
        this.mekaSuitNutritionalMaxStorage = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_MEKA_SUIT_PASTE_CAPACITY.applyToBuilder(builder).defineInRange("nutritionalMaxStorage", 128000, 1, Integer.MAX_VALUE));
        this.mekaSuitNutritionalTransferRate = CachedIntValue.wrap(this, (ModConfigSpec.ConfigValue<Integer>)MekanismConfigTranslations.GEAR_MEKA_SUIT_PASTE_TRANSFER_RATE.applyToBuilder(builder).defineInRange("nutritionalTransferRate", 256, 1, Integer.MAX_VALUE));
        this.mekaSuitJetpackMaxStorage = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GEAR_MEKA_SUIT_JETPACK_CAPACITY.applyToBuilder(builder).defineInRange("jetpackMaxStorage", 24000L, 1L, Long.MAX_VALUE));
        this.mekaSuitJetpackTransferRate = CachedLongValue.wrap(this, (ModConfigSpec.ConfigValue<Long>)MekanismConfigTranslations.GEAR_MEKA_SUIT_JETPACK_TRANSFER_RATE.applyToBuilder(builder).defineInRange("jetpackTransferRate", 256L, 1L, Long.MAX_VALUE));
        MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE.applyToBuilder(builder).push("energy_usage");
        this.mekaSuitEnergyUsageDamage = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_DAMAGE, "damage", 100000L);
        this.mekaSuitEnergyUsageMagicReduce = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_MAGIC, "magicReduce", 1000L);
        this.mekaSuitEnergyUsageFall = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_FALL, "fall", 50L);
        this.mekaSuitBaseJumpEnergyUsage = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_JUMP, "jump", 1000L);
        this.mekaSuitElytraEnergyUsage = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_ELYTRA, "elytra", 32000L);
        this.mekaSuitEnergyUsagePotionTick = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_POTION, "energyUsagePotionTick", 40000L);
        this.mekaSuitEnergyUsageSprintBoost = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_SPRINT, "sprintBoost", 100L);
        this.mekaSuitEnergyUsageGravitationalModulation = CachedLongValue.define(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_FLIGHT, "gravitationalModulation", 1000L, 0L, 0x1FFFFFFFFFFFFFFFL);
        this.mekaSuitEnergyUsageVisionEnhancement = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_VISION, "visionEnhancement", 500L);
        this.mekaSuitEnergyUsageHydrostaticRepulsion = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_SWIM, "hydrostaticRepulsion", 500L);
        this.mekaSuitEnergyUsageNutritionalInjection = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_FOOD, "nutritionalInjection", 20000L);
        this.mekaSuitEnergyUsageItemAttraction = CachedLongValue.definePositive(this, builder, MekanismConfigTranslations.GEAR_MEKA_SUIT_ENERGY_USAGE_MAGNET, "itemAttraction", 250L);
        builder.pop();
        MekanismConfigTranslations.GEAR_MEKA_SUIT_DAMAGE_ABSORPTION.applyToBuilder(builder).push(MEKASUIT_DAMAGE_CATEGORY);
        this.mekaSuitFallDamageRatio = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GEAR_MEKA_SUIT_ABSORPTION_FALL.applyToBuilder(builder).defineInRange("fallDamageReductionRatio", 1.0, 0.0, 1.0));
        this.mekaSuitMagicDamageRatio = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GEAR_MEKA_SUIT_ABSORPTION_MAGIC.applyToBuilder(builder).defineInRange("magicDamageReductionRatio", 1.0, 0.0, 1.0));
        this.mekaSuitUnspecifiedDamageRatio = CachedFloatValue.wrap(this, (ModConfigSpec.ConfigValue<Double>)MekanismConfigTranslations.GEAR_MEKA_SUIT_ABSORPTION_UNSPECIFIED.applyToBuilder(builder).defineInRange("unspecifiedDamageReductionRatio", 1.0, 0.0, 1.0));
        builder.pop(2);
        this.configSpec = builder.build();
    }

    @Override
    public String getFileName() {
        return "gear";
    }

    @Override
    public String getTranslation() {
        return "Gear Config";
    }

    @Override
    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    @Override
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

