/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.basic.BasicPressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.ReactionRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Reaction")
public class PressurizedReactionRecipeManager
extends MekanismRecipeManager<ReactionRecipeInput, PressurizedReactionRecipe> {
    public static final PressurizedReactionRecipeManager INSTANCE = new PressurizedReactionRecipeManager();

    private PressurizedReactionRecipeManager() {
        super(MekanismRecipeType.REACTION);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, ChemicalStackIngredient inputChemical, int duration, IItemStack outputItem, long energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputChemical, duration, this.getAndValidateNotEmpty(outputItem), ChemicalStack.EMPTY, energyRequired);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, ChemicalStackIngredient inputChemical, int duration, IItemStack outputItem) {
        this.addRecipe(name, inputSolid, inputFluid, inputChemical, duration, this.getAndValidateNotEmpty(outputItem), ChemicalStack.EMPTY, 0L);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, ChemicalStackIngredient inputChemical, int duration, ICrTChemicalStack outputChemical, long energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputChemical, duration, ItemStack.EMPTY, this.getAndValidateNotEmpty(outputChemical), energyRequired);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, ChemicalStackIngredient inputChemical, int duration, ICrTChemicalStack outputChemical) {
        this.addRecipe(name, inputSolid, inputFluid, inputChemical, duration, ItemStack.EMPTY, this.getAndValidateNotEmpty(outputChemical), 0L);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, ChemicalStackIngredient inputChemical, int duration, IItemStack outputItem, ICrTChemicalStack outputChemical, long energyRequired) {
        this.addRecipe(name, inputSolid, inputFluid, inputChemical, duration, this.getAndValidateNotEmpty(outputItem), this.getAndValidateNotEmpty(outputChemical), energyRequired);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, ChemicalStackIngredient inputChemical, int duration, IItemStack outputItem, ICrTChemicalStack outputChemical) {
        this.addRecipe(name, inputSolid, inputFluid, inputChemical, duration, this.getAndValidateNotEmpty(outputItem), this.getAndValidateNotEmpty(outputChemical), 0L);
    }

    private void addRecipe(String name, IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, ChemicalStackIngredient inputChemical, int duration, ItemStack outputItem, ChemicalStack outputChemical, long energyRequired) {
        this.addRecipe(name, this.makeRecipe(inputSolid, inputFluid, inputChemical, duration, outputItem, outputChemical, energyRequired));
    }

    public PressurizedReactionRecipe makeRecipe(IIngredientWithAmount inputSolid, CTFluidIngredient inputFluid, ChemicalStackIngredient inputChemical, int duration, ItemStack outputItem, ChemicalStack outputChemical, long energyRequired) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive! Duration: " + duration);
        }
        return new BasicPressurizedReactionRecipe(CrTUtils.fromCrT(inputSolid), CrTUtils.fromCrT(inputFluid), inputChemical, energyRequired, duration, outputItem, outputChemical);
    }

    @Override
    protected String describeOutputs(PressurizedReactionRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), output -> {
            ChemicalStack chemicalOutput;
            StringBuilder builder = new StringBuilder();
            ItemStack itemOutput = output.item();
            if (!itemOutput.isEmpty()) {
                builder.append(ItemStackUtil.getCommandString((ItemStack)itemOutput));
            }
            if (!(chemicalOutput = output.chemical()).isEmpty()) {
                if (!itemOutput.isEmpty()) {
                    builder.append(" and ");
                }
                builder.append(new CrTChemicalStack(chemicalOutput));
            }
            return builder.toString();
        });
    }
}

