/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.entity.robit;

import mekanism.api.security.IEntitySecurityUtils;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.ISecurityContainer;
import mekanism.common.inventory.container.entity.IEntityContainer;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;

public class RepairRobitContainer
extends AnvilMenu
implements IEntityContainer<EntityRobit>,
ISecurityContainer {
    private final EntityRobit entity;

    public RepairRobitContainer(int id, Inventory inv, EntityRobit robit) {
        super(id, inv, robit.getWorldPosCallable());
        this.entity = robit;
        this.entity.open(inv.player);
    }

    public boolean stillValid(@NotNull Player player) {
        return this.entity.isAlive();
    }

    @Override
    @NotNull
    public EntityRobit getEntity() {
        return this.entity;
    }

    @NotNull
    public MenuType<?> getType() {
        return (MenuType)MekanismContainerTypes.REPAIR_ROBIT.get();
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.entity.close(player);
    }

    @Override
    public boolean canPlayerAccess(@NotNull Player player) {
        return IEntitySecurityUtils.INSTANCE.canAccess(player, this.entity);
    }
}

