/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.common.registration.DoubleWrappedRegistryObject;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DoubleDeferredRegister<PRIMARY, SECONDARY> {
    private final DeferredRegister<PRIMARY> primaryRegister;
    private final DeferredRegister<SECONDARY> secondaryRegister;

    protected DoubleDeferredRegister(DeferredRegister<PRIMARY> primaryRegistry, DeferredRegister<SECONDARY> secondaryRegistry) {
        this.primaryRegister = primaryRegistry;
        this.secondaryRegister = secondaryRegistry;
    }

    protected DoubleDeferredRegister(String modid, ResourceKey<? extends Registry<PRIMARY>> primaryRegistryName, ResourceKey<? extends Registry<SECONDARY>> secondaryRegistryName) {
        this(modid, primaryRegistryName, DeferredRegister.create(secondaryRegistryName, (String)modid));
    }

    protected DoubleDeferredRegister(String modid, ResourceKey<? extends Registry<PRIMARY>> primaryRegistryName, DeferredRegister<SECONDARY> secondaryRegistry) {
        this(DeferredRegister.create(primaryRegistryName, (String)modid), secondaryRegistry);
    }

    public <P extends PRIMARY, S extends SECONDARY, W extends DoubleWrappedRegistryObject<PRIMARY, P, SECONDARY, S>> W register(String name, Supplier<? extends P> primarySupplier, Supplier<? extends S> secondarySupplier, BiFunction<DeferredHolder<PRIMARY, P>, DeferredHolder<SECONDARY, S>, W> objectWrapper) {
        return (W)((DoubleWrappedRegistryObject)objectWrapper.apply(this.primaryRegister.register(name, primarySupplier), this.secondaryRegister.register(name, secondarySupplier)));
    }

    public <P extends PRIMARY, S extends SECONDARY, W extends DoubleWrappedRegistryObject<PRIMARY, P, SECONDARY, S>> W register(String name, Supplier<? extends P> primarySupplier, Function<P, S> secondarySupplier, BiFunction<DeferredHolder<PRIMARY, P>, DeferredHolder<SECONDARY, S>, W> objectWrapper) {
        return this.registerAdvanced(name, primarySupplier, secondarySupplier.compose(Supplier::get), objectWrapper);
    }

    public <P extends PRIMARY, S extends SECONDARY, W extends DoubleWrappedRegistryObject<PRIMARY, P, SECONDARY, S>> W registerAdvanced(String name, Supplier<? extends P> primarySupplier, Function<DeferredHolder<PRIMARY, P>, S> secondarySupplier, BiFunction<DeferredHolder<PRIMARY, P>, DeferredHolder<SECONDARY, S>, W> objectWrapper) {
        DeferredHolder primaryObject = this.primaryRegister.register(name, primarySupplier);
        return (W)((DoubleWrappedRegistryObject)objectWrapper.apply(primaryObject, this.secondaryRegister.register(name, () -> secondarySupplier.apply(primaryObject))));
    }

    public void register(IEventBus bus) {
        this.primaryRegister.register(bus);
        this.secondaryRegister.register(bus);
    }

    public Collection<DeferredHolder<PRIMARY, ? extends PRIMARY>> getPrimaryEntries() {
        return this.primaryRegister.getEntries();
    }

    public Collection<DeferredHolder<SECONDARY, ? extends SECONDARY>> getSecondaryEntries() {
        return this.secondaryRegister.getEntries();
    }
}

