/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component.config;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

@NothingNullByDefault
public enum DataType implements IIncrementalEnum<DataType>,
IHasTranslationKey.IHasEnumNameTranslationKey,
StringRepresentable
{
    NONE(MekanismLang.SIDE_DATA_NONE, EnumColor.GRAY),
    INPUT(MekanismLang.SIDE_DATA_INPUT, EnumColor.DARK_RED),
    INPUT_1(MekanismLang.SIDE_DATA_INPUT_1, EnumColor.DARK_RED),
    INPUT_2(MekanismLang.SIDE_DATA_INPUT_2, EnumColor.ORANGE),
    OUTPUT(MekanismLang.SIDE_DATA_OUTPUT, EnumColor.DARK_BLUE),
    OUTPUT_1(MekanismLang.SIDE_DATA_OUTPUT_1, EnumColor.DARK_BLUE),
    OUTPUT_2(MekanismLang.SIDE_DATA_OUTPUT_2, EnumColor.DARK_AQUA),
    INPUT_OUTPUT(MekanismLang.SIDE_DATA_INPUT_OUTPUT, EnumColor.PURPLE),
    ENERGY(MekanismLang.SIDE_DATA_ENERGY, EnumColor.DARK_GREEN),
    EXTRA(MekanismLang.SIDE_DATA_EXTRA, EnumColor.YELLOW);

    public static final Codec<DataType> CODEC;
    public static final IntFunction<DataType> BY_ID;
    public static final StreamCodec<ByteBuf, DataType> STREAM_CODEC;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final EnumColor color;
    private final ILangEntry langEntry;

    private DataType(ILangEntry langEntry, EnumColor color) {
        this.color = color;
        this.langEntry = langEntry;
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    @Override
    public DataType byIndex(int index) {
        return BY_ID.apply(index);
    }

    public boolean canOutput() {
        return this == OUTPUT || this == INPUT_OUTPUT || this == OUTPUT_1 || this == OUTPUT_2;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(DataType::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])DataType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

