/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.network.FilterPacket;
import com.flanks255.simplybackpacks.network.HotkeyPacket;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class FilterContainer
extends AbstractContainerMenu {
    public final FilterItemHandler filterHandler;
    private int slotID;
    private final Player playerEntity;
    private final ItemStack stack;

    public static FilterContainer fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf extra) {
        CompoundTag nbt = extra.readNbt();
        FilterItemHandler handler = new FilterItemHandler();
        handler.deserializeNBT((HolderLookup.Provider)playerInventory.player.registryAccess(), nbt);
        return new FilterContainer(windowId, playerInventory, handler);
    }

    public FilterContainer(int windowId, Inventory playerInventory, FilterItemHandler handlerIn) {
        super((MenuType)SimplyBackpacks.FILTERCONTAINER.get(), windowId);
        this.playerEntity = playerInventory.player;
        this.stack = this.findBackpack(this.playerEntity);
        this.filterHandler = handlerIn;
        this.addPlayerSlots(playerInventory);
    }

    public boolean stillValid(@Nonnull Player playerIn) {
        if (this.slotID == -106) {
            return playerIn.getOffhandItem().getItem() instanceof BackpackItem;
        }
        return playerIn.getInventory().getItem(this.slotID).getItem() instanceof BackpackItem;
    }

    private ItemStack findBackpack(Player playerEntity) {
        Inventory inv = playerEntity.getInventory();
        if (playerEntity.getMainHandItem().getItem() instanceof BackpackItem) {
            for (int i = 0; i <= 8; ++i) {
                ItemStack stack = inv.getItem(i);
                if (stack != playerEntity.getMainHandItem()) continue;
                this.slotID = i;
                return stack;
            }
        } else {
            if (playerEntity.getOffhandItem().getItem() instanceof BackpackItem) {
                this.slotID = -106;
                return playerEntity.getOffhandItem();
            }
            for (int i = 0; i <= 8; ++i) {
                ItemStack stack = inv.getItem(i);
                if (!(stack.getItem() instanceof BackpackItem)) continue;
                this.slotID = i;
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public void clicked(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player playerIn) {
        if (slotId >= 0 && this.getSlot(slotId).getItem() == playerIn.getMainHandItem()) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        if (slotId >= 0) {
            this.getSlot((int)slotId).container.setChanged();
        }
        super.clicked(slotId, dragType, clickTypeIn, playerIn);
    }

    public int getFilterOpts() {
        return (Integer)this.stack.getOrDefault(SimplyBackpacks.BACKPACK_FILTER, (Object)0);
    }

    public boolean getPickup() {
        return (Boolean)this.stack.getOrDefault(SimplyBackpacks.BACKPACK_PICKUP, (Object)false);
    }

    public boolean togglePickup() {
        boolean Pickup = (Boolean)this.stack.getOrDefault(SimplyBackpacks.BACKPACK_PICKUP, (Object)false) == false;
        this.stack.set(SimplyBackpacks.BACKPACK_PICKUP, (Object)Pickup);
        if (this.playerEntity.getCommandSenderWorld().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new HotkeyPacket(HotkeyPacket.HotKey.TOGGLE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return Pickup;
    }

    public int saveFilterClient(int newOpts) {
        this.stack.set(SimplyBackpacks.BACKPACK_FILTER, (Object)newOpts);
        if (this.playerEntity.getCommandSenderWorld().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new FilterPacket(newOpts), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return newOpts;
    }

    public void saveFilterServer(int newOpts) {
        this.stack.set(SimplyBackpacks.BACKPACK_FILTER, (Object)newOpts);
    }

    public void addPlayerSlots(Inventory playerInventory) {
        int originX = 7;
        int originY = 83;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, x + 1, y + 1));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            this.addSlot(new Slot((Container)playerInventory, col, x + 1, y + 1));
        }
    }

    public boolean clickMenuButton(Player playerIn, int id) {
        if (this.getCarried().isEmpty()) {
            this.filterHandler.removeItem(id);
        } else {
            ItemStack fake = this.getCarried().copy();
            fake.setCount(1);
            this.filterHandler.setItem(id, fake);
        }
        return true;
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        for (int i = 0; i < this.filterHandler.getSlots(); ++i) {
            if (!this.filterHandler.getStackInSlot(i).isEmpty()) continue;
            ItemStack fake = slot.getItem().copy();
            fake.setCount(1);
            this.filterHandler.setItem(i, fake);
            break;
        }
        return ItemStack.EMPTY;
    }
}

