/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis.params;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.sinytra.adapter.patch.analysis.params.ParamsDiffSnapshot;
import org.sinytra.adapter.patch.analysis.params.ParamsDiffSnapshotBuilder;
import org.sinytra.adapter.patch.analysis.params.SimpleParamsDiffSnapshot;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.transformer.operation.param.InjectParameterTransform;
import org.sinytra.adapter.patch.transformer.operation.param.InlineParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.MoveParametersTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformTarget;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.RemoveParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.ReplaceParametersTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.SubstituteParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.SwapParametersTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.TransformParameters;

public record LayeredParamsDiffSnapshot(List<ParamModification> modifications) implements ParamsDiffSnapshot
{
    public static LayeredParamsDiffSnapshot EMPTY = new LayeredParamsDiffSnapshot(List.of());

    @Override
    public boolean isEmpty() {
        return this.modifications.isEmpty();
    }

    @Override
    public List<Pair<Integer, Type>> insertions() {
        return this.modifications.stream().map(p -> {
            InsertParam param;
            return p instanceof InsertParam ? (param = (InsertParam)p) : null;
        }).filter(Objects::nonNull).map(p -> Pair.of((Object)p.index, (Object)p.type)).toList();
    }

    @Override
    public List<Pair<Integer, Type>> replacements() {
        return this.modifications.stream().map(p -> {
            ReplaceParam param;
            return p instanceof ReplaceParam ? (param = (ReplaceParam)p) : null;
        }).filter(Objects::nonNull).map(p -> Pair.of((Object)p.index, (Object)p.type)).toList();
    }

    public List<Pair<Integer, Integer>> swaps() {
        return this.modifications.stream().map(p -> {
            SwapParam param;
            return p instanceof SwapParam ? (param = (SwapParam)p) : null;
        }).filter(Objects::nonNull).map(p -> Pair.of((Object)p.from(), (Object)p.to())).toList();
    }

    public List<Pair<Integer, Integer>> moves() {
        return this.modifications.stream().map(p -> {
            MoveParam param;
            return p instanceof MoveParam ? (param = (MoveParam)p) : null;
        }).filter(Objects::nonNull).map(p -> Pair.of((Object)p.from(), (Object)p.to())).toList();
    }

    @Override
    public List<Integer> removals() {
        return this.modifications.stream().map(p -> {
            Integer n;
            if (p instanceof RemoveParam) {
                RemoveParam param = (RemoveParam)p;
                n = param.index;
            } else {
                n = null;
            }
            return n;
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public LayeredParamsDiffSnapshot offset(int offset, int limit) {
        return new LayeredParamsDiffSnapshot(this.modifications.stream().filter(p -> p.satisfiesIndexLimit(limit)).map(p -> p.offset(offset)).toList());
    }

    @Override
    public MethodTransform asParameterTransformer(ParamTransformTarget type, boolean withOffset, Set<ParamsDiffSnapshot.Flags> flags) {
        List<ParameterTransformer> transformers = this.modifications.stream().map(paramModification -> paramModification.asParameterTransformer(flags)).toList();
        return TransformParameters.builder().transform(transformers).withOffset(withOffset).targetType(type).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ParamsDiffSnapshotBuilder {
        private final ImmutableList.Builder<ParamModification> modifications = ImmutableList.builder();
        private final List<Integer> removals = new ArrayList<Integer>();

        private Builder() {
        }

        @Override
        public Builder insert(int index, Type type) {
            this.modifications.add((Object)new InsertParam(index, type));
            return this;
        }

        @Override
        public Builder insertions(List<Pair<Integer, Type>> insertions) {
            insertions.forEach(p -> this.insert((Integer)p.getFirst(), (Type)p.getSecond()));
            return this;
        }

        @Override
        public Builder replace(int index, Type type) {
            this.modifications.add((Object)new ReplaceParam(index, type));
            return this;
        }

        @Override
        public Builder replacements(List<Pair<Integer, Type>> replacements) {
            replacements.forEach(p -> this.replace((Integer)p.getFirst(), (Type)p.getSecond()));
            return this;
        }

        @Override
        public Builder swap(int from, int to) {
            this.modifications.add((Object)new SwapParam(from, to));
            return this;
        }

        @Override
        public Builder swaps(List<Pair<Integer, Integer>> swaps) {
            swaps.forEach(p -> this.swap((Integer)p.getFirst(), (Integer)p.getSecond()));
            return this;
        }

        @Override
        public Builder substitute(int target, int substitute) {
            this.modifications.add((Object)new SubstituteParam(target, substitute));
            return this;
        }

        @Override
        public Builder substitutes(List<Pair<Integer, Integer>> substitutes) {
            substitutes.forEach(p -> this.substitute((Integer)p.getFirst(), (Integer)p.getSecond()));
            return this;
        }

        @Override
        public Builder move(int from, int to) {
            this.modifications.add((Object)new MoveParam(from, to));
            return this;
        }

        @Override
        public Builder moves(List<Pair<Integer, Integer>> moves) {
            moves.forEach(p -> this.move((Integer)p.getFirst(), (Integer)p.getSecond()));
            return this;
        }

        @Override
        public Builder remove(int index) {
            this.modifications.add((Object)new RemoveParam(index));
            this.removals.add(index);
            return this;
        }

        @Override
        public Builder removals(List<Integer> removals) {
            removals.forEach(this::remove);
            return this;
        }

        @Override
        public Builder inline(int target, Consumer<InstructionAdapter> adapter) {
            this.modifications.add((Object)new InlineParam(target, adapter));
            return this;
        }

        @Override
        public Builder inlines(List<Pair<Integer, Consumer<InstructionAdapter>>> inlines) {
            inlines.forEach(p -> this.inline((int)((Integer)p.getFirst()), (Consumer)p.getSecond()));
            return this;
        }

        @Override
        public Builder merge(SimpleParamsDiffSnapshot diff) {
            return this.merge(diff, 0);
        }

        @Override
        public Builder merge(SimpleParamsDiffSnapshot diff, int indexOffset) {
            diff.insertions().forEach(p -> this.insert((Integer)p.getFirst() + indexOffset, (Type)p.getSecond()));
            diff.replacements().forEach(p -> this.replace((Integer)p.getFirst() + indexOffset, (Type)p.getSecond()));
            diff.swaps().forEach(p -> this.swap((Integer)p.getFirst() + indexOffset, (Integer)p.getSecond() + indexOffset));
            diff.substitutes().forEach(p -> this.substitute((Integer)p.getFirst() + indexOffset, (Integer)p.getSecond() + indexOffset));
            diff.removals().forEach(p -> this.remove(p + indexOffset));
            diff.moves().forEach(p -> this.move((Integer)p.getFirst() + indexOffset, (Integer)p.getSecond() + indexOffset));
            diff.inlines().forEach(p -> this.inline((Integer)p.getFirst() + indexOffset, (Consumer)p.getSecond()));
            return this;
        }

        @Override
        public List<Integer> getRemovals() {
            return List.copyOf(this.removals);
        }

        @CheckReturnValue
        public LayeredParamsDiffSnapshot build() {
            return new LayeredParamsDiffSnapshot((List<ParamModification>)this.modifications.build());
        }
    }

    public static interface ParamModification {
        public ParamModification offset(int var1);

        public boolean satisfiesIndexLimit(int var1);

        public ParameterTransformer asParameterTransformer(Set<ParamsDiffSnapshot.Flags> var1);
    }

    record RemoveParam(int index) implements ParamModification
    {
        @Override
        public ParamModification offset(int offset) {
            return new RemoveParam(this.index + offset);
        }

        @Override
        public boolean satisfiesIndexLimit(int index) {
            return this.index < index;
        }

        @Override
        public ParameterTransformer asParameterTransformer(Set<ParamsDiffSnapshot.Flags> flags) {
            return new RemoveParameterTransformer(this.index);
        }
    }

    record MoveParam(int from, int to) implements ParamModification
    {
        @Override
        public ParamModification offset(int offset) {
            return new MoveParam(this.from + offset, this.to + offset);
        }

        @Override
        public boolean satisfiesIndexLimit(int index) {
            return this.from < index;
        }

        @Override
        public ParameterTransformer asParameterTransformer(Set<ParamsDiffSnapshot.Flags> flags) {
            return new MoveParametersTransformer(this.from, this.to);
        }
    }

    record SwapParam(int from, int to) implements ParamModification
    {
        @Override
        public ParamModification offset(int offset) {
            return new SwapParam(this.from + offset, this.to + offset);
        }

        @Override
        public boolean satisfiesIndexLimit(int index) {
            return this.from < index;
        }

        @Override
        public ParameterTransformer asParameterTransformer(Set<ParamsDiffSnapshot.Flags> flags) {
            return new SwapParametersTransformer(this.from, this.to);
        }
    }

    record ReplaceParam(int index, Type type) implements ParamModification
    {
        @Override
        public ParamModification offset(int offset) {
            return new ReplaceParam(this.index + offset, this.type);
        }

        @Override
        public boolean satisfiesIndexLimit(int index) {
            return this.index < index;
        }

        @Override
        public ParameterTransformer asParameterTransformer(Set<ParamsDiffSnapshot.Flags> flags) {
            return new ReplaceParametersTransformer(this.index, this.type, flags.contains((Object)ParamsDiffSnapshot.Flags.UPGRADE_WRAP_OP));
        }
    }

    public record InsertParam(int index, Type type) implements ParamModification
    {
        @Override
        public ParamModification offset(int offset) {
            return new InsertParam(this.index + offset, this.type);
        }

        @Override
        public boolean satisfiesIndexLimit(int index) {
            return this.index < index;
        }

        @Override
        public ParameterTransformer asParameterTransformer(Set<ParamsDiffSnapshot.Flags> flags) {
            return new InjectParameterTransform(this.index, this.type);
        }
    }

    record SubstituteParam(int target, int substitute) implements ParamModification
    {
        @Override
        public ParamModification offset(int offset) {
            return new SubstituteParam(this.target + offset, this.substitute + offset);
        }

        @Override
        public boolean satisfiesIndexLimit(int index) {
            return this.target < index;
        }

        @Override
        public ParameterTransformer asParameterTransformer(Set<ParamsDiffSnapshot.Flags> flags) {
            return new SubstituteParameterTransformer(this.target, this.substitute);
        }
    }

    record InlineParam(int target, Consumer<InstructionAdapter> adapter) implements ParamModification
    {
        @Override
        public ParamModification offset(int offset) {
            return new InlineParam(this.target + offset, this.adapter);
        }

        @Override
        public boolean satisfiesIndexLimit(int index) {
            return this.target < index;
        }

        @Override
        public ParameterTransformer asParameterTransformer(Set<ParamsDiffSnapshot.Flags> flags) {
            return new InlineParameterTransformer(this.target, this.adapter);
        }
    }
}

