/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBigLight;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiMergedTankGauge;
import mekanism.client.gui.element.graph.GuiDoubleGraph;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.tab.GuiWarningTab;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.IWarningTracker;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.element.GuiFissionReactorTab;
import mekanism.generators.client.recipe_viewer.GeneratorsRVRecipeType;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.network.to_server.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiFissionReactor
extends GuiMekanismTile<TileEntityFissionReactorCasing, MekanismTileContainer<TileEntityFissionReactorCasing>> {
    private TranslationButton activateButton;
    private TranslationButton scramButton;
    private GuiDoubleGraph heatGraph;

    public GuiFissionReactor(MekanismTileContainer<TileEntityFissionReactorCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageWidth = 195;
        this.imageHeight += 89;
        this.inventoryLabelX = 6;
        this.inventoryLabelY = this.imageHeight - 92;
        this.titleLabelY = 5;
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiFissionReactorTab((IGuiWrapper)this, (TileEntityFissionReactorCasing)this.tile, GuiFissionReactorTab.FissionReactorTab.STAT));
        this.addRenderableWidget((GuiElement)new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56, () -> {
            FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
            return List.of(MekanismLang.STATUS.translate(new Object[]{multiblock.isActive() ? EnumColor.BRIGHT_GREEN : EnumColor.RED, BooleanStateDisplay.ActiveDisabled.of((boolean)multiblock.isActive())}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{multiblock.lastBurnRate}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{TextUtils.format((long)multiblock.lastBoilRate)}), MekanismLang.TEMPERATURE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getTempColor(), MekanismUtils.getTemperatureDisplay((double)multiblock.heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getDamageColor(), ((TileEntityFissionReactorCasing)this.tile).getDamageString()}));
        }).spacing(1).recipeViewerCategories(new IRecipeViewerRecipeType[]{GeneratorsRVRecipeType.FISSION}));
        this.addRenderableWidget((GuiElement)new GuiMergedTankGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).coolantTank, () -> ((TileEntityFissionReactorCasing)((TileEntityFissionReactorCasing)this.tile)).getMultiblock(), GaugeType.STANDARD, (IGuiWrapper)this, 6, 13).setLabel((Component)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA)));
        this.addRenderableWidget((GuiElement)new GuiChemicalGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fuelTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getChemicalTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 25, 13).setLabel((Component)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN)));
        this.addRenderableWidget((GuiElement)new GuiChemicalGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatedCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getChemicalTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 152, 13).setLabel((Component)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE)));
        this.addRenderableWidget((GuiElement)new GuiChemicalGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).wasteTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getChemicalTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 171, 13).setLabel((Component)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN)));
        this.addRenderableWidget((GuiElement)new GuiHeatTab((IGuiWrapper)this, () -> {
            Component environment = MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }));
        this.activateButton = (TranslationButton)this.addRenderableWidget((GuiElement)new TranslationButton((IGuiWrapper)this, 6, 75, 81, 16, GeneratorsLang.FISSION_ACTIVATE, (element, mouseX, mouseY) -> PacketUtils.sendToServer((CustomPacketPayload)new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (BlockEntity)((GuiFissionReactor)element.gui()).tile, 1.0)), () -> EnumColor.DARK_GREEN){

            public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
                super.renderForeground(guiGraphics, mouseX, mouseY);
                if (!this.active && ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)GuiFissionReactor.this.tile).getMultiblock()).isForceDisabled()) {
                    this.active = true;
                    if (this.isMouseOverCheckWindows(mouseX, mouseY)) {
                        PoseStack pose = guiGraphics.pose();
                        pose.pushPose();
                        pose.translate((float)(-this.getGuiLeft()), (float)(-this.getGuiTop()), 0.0f);
                        guiGraphics.renderTooltip(GuiFissionReactor.this.font, GuiFissionReactor.this.font.split((FormattedText)GeneratorsLang.FISSION_FORCE_DISABLED.translate(), 170), mouseX, mouseY);
                        pose.popPose();
                    }
                    this.active = false;
                }
            }
        });
        this.scramButton = (TranslationButton)this.addRenderableWidget((GuiElement)new TranslationButton((IGuiWrapper)this, 89, 75, 81, 16, (ILangEntry)GeneratorsLang.FISSION_SCRAM, (element, mouseX, mouseY) -> PacketUtils.sendToServer((CustomPacketPayload)new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (BlockEntity)((GuiFissionReactor)element.gui()).tile, 0.0)), () -> EnumColor.DARK_RED));
        this.addRenderableWidget((GuiElement)new GuiBigLight((IGuiWrapper)this, 173, 76, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock())::isActive));
        this.addRenderableWidget((GuiElement)new GuiDynamicHorizontalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                return MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactor)GuiFissionReactor.this).tile).getMultiblock()).heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true);
            }

            public double getLevel() {
                return Math.min(1.0, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactor)GuiFissionReactor.this).tile).getMultiblock()).heatCapacitor.getTemperature() / 1800.0);
            }
        }, 5, 102, this.imageWidth - 12));
        this.heatGraph = (GuiDoubleGraph)this.addRenderableWidget((GuiElement)new GuiDoubleGraph((IGuiWrapper)this, 5, 123, this.imageWidth - 10, 38, temp -> MekanismUtils.getTemperatureDisplay((double)temp, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)));
        this.heatGraph.setMinScale(1600.0);
        this.updateButtons();
    }

    private void updateButtons() {
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
        this.activateButton.active = !multiblock.isActive() && !multiblock.isForceDisabled();
        this.scramButton.active = multiblock.isActive();
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.updateButtons();
        this.renderTitleText(guiGraphics);
        this.renderInventoryText(guiGraphics);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.TEMPERATURE_LONG.translate(new Object[]{""}), 0, 93, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 5, false);
        this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.FISSION_HEAT_GRAPH.translate(), 0, 114, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 5, false);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    public void containerTick() {
        super.containerTick();
        this.heatGraph.addData(((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatCapacitor.getTemperature());
    }

    protected void addWarningTab(IWarningTracker warningTracker) {
        this.addRenderableWidget((GuiElement)new GuiWarningTab((IGuiWrapper)this, warningTracker, false));
    }
}

