/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei.recipes;

import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.core.localization.ItemModText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public record AttunementRecipe(Ingredient inputs, Item tunnel, @Nullable ResourceLocation uid, Component[] description) {
    public static List<AttunementRecipe> createAllRecipes() {
        ArrayList<AttunementRecipe> results = new ArrayList<AttunementRecipe>();
        for (P2PTunnelAttunementInternal.Resultant resultant : P2PTunnelAttunementInternal.getApiTunnels()) {
            AttunementRecipe attunementRecipe = AttunementRecipe.createAttunementDisplay(resultant);
            if (attunementRecipe.inputs().isEmpty()) continue;
            results.add(attunementRecipe);
        }
        for (Map.Entry entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
            TagKey tagKey = (TagKey)entry.getKey();
            Item tunnelType = (Item)entry.getValue();
            AttunementRecipe attunementRecipe = AttunementRecipe.createAttunementDisplay(tunnelType, (TagKey<Item>)tagKey);
            if (attunementRecipe.inputs().isEmpty()) continue;
            results.add(attunementRecipe);
        }
        return results;
    }

    private static AttunementRecipe createAttunementDisplay(P2PTunnelAttunementInternal.Resultant entry) {
        Item tunnelType = entry.tunnelType();
        Stream<ItemStack> inputs = BuiltInRegistries.ITEM.stream().map(ItemStack::new).filter(entry.stackPredicate());
        return new AttunementRecipe(Ingredient.of(inputs), tunnelType, AttunementRecipe.getUid(tunnelType), new Component[]{ItemModText.P2P_API_ATTUNEMENT.text(), entry.description()});
    }

    private static AttunementRecipe createAttunementDisplay(Item tunnelType, TagKey<Item> tagKey) {
        return new AttunementRecipe(Ingredient.of(tagKey), tunnelType, AttunementRecipe.getUid(tunnelType), new Component[]{ItemModText.P2P_TAG_ATTUNEMENT.text()});
    }

    @Nullable
    private static ResourceLocation getUid(Item tunnelType) {
        ResourceKey attunementKey = tunnelType.builtInRegistryHolder().getKey();
        return attunementKey == null ? null : attunementKey.location();
    }
}

