/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.ITextElement;
import snownee.jade.impl.ui.TextElement;
import snownee.jade.overlay.DisplayHelper;

public class SpecialTextElement
extends TextElement {
    private float scale = 1.0f;
    private int zOffset;

    public SpecialTextElement(FormattedText text) {
        super(text);
    }

    @Override
    public Vec2 getSize() {
        Font font = Minecraft.getInstance().font;
        float f = (float)font.width(this.text) * this.scale;
        Objects.requireNonNull(font);
        return new Vec2(f, 9.0f * this.scale + 1.0f);
    }

    @Override
    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(x, y + this.scale, (float)this.zOffset);
        matrixStack.scale(this.scale, this.scale, 1.0f);
        DisplayHelper.INSTANCE.drawText(guiGraphics, this.text, 0.0f, 0.0f, IThemeHelper.get().getNormalColor());
        matrixStack.popPose();
    }

    @Override
    public SpecialTextElement toSpecial() {
        return this;
    }

    @Override
    public ITextElement scale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public ITextElement zOffset(int zOffset) {
        this.zOffset = zOffset;
        return this;
    }
}

