/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import java.util.EnumMap;
import java.util.Map;
import mekanism.api.Upgrade;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.DigitalButton;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.custom.GuiSupportedUpgrades;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.scroll.GuiUpgradeScrollList;
import mekanism.client.gui.element.slot.GuiVirtualSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiUpgradeWindow
extends GuiWindow {
    private final Map<Upgrade, IFancyFontRenderer.WrappedTextRenderer> upgradeTypeData = new EnumMap<Upgrade, IFancyFontRenderer.WrappedTextRenderer>(Upgrade.class);
    private final IFancyFontRenderer.WrappedTextRenderer noSelection = new IFancyFontRenderer.WrappedTextRenderer(this, (Component)MekanismLang.UPGRADE_NO_SELECTION.translate());
    private final TileEntityMekanism tile;
    private final MekanismButton removeButton;
    private final GuiUpgradeScrollList scrollList;
    private final GuiInnerScreen rightScreen;
    private long msSelected;

    public GuiUpgradeWindow(IGuiWrapper gui, int x, int y, TileEntityMekanism tile, SelectedWindowData windowData) {
        super(gui, x, y, 198, 76 + Math.max(18, 12 * GuiSupportedUpgrades.calculateNeededRows(gui)), windowData);
        if (windowData.type != SelectedWindowData.WindowType.UPGRADE) {
            throw new IllegalArgumentException("Upgrade windows must have an upgrade window type");
        }
        this.tile = tile;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        this.scrollList = this.addChild(new GuiUpgradeScrollList(gui, this.relativeX + 6, this.relativeY + 18, 50, tile.getComponent(), () -> {
            this.updateEnabledButtons();
            this.msSelected = Util.getMillis();
        }));
        this.addChild(new GuiSupportedUpgrades(gui, this.relativeX + 6, this.relativeY + 68, tile.getComponent().getSupportedTypes()));
        this.rightScreen = this.addChild(new GuiInnerScreen(gui, this.scrollList.getRelativeRight(), this.relativeY + 18, 59, 50));
        this.addChild(new GuiProgress(() -> this.tile.getComponent().getScaledUpgradeProgress(), ProgressType.INSTALLING, gui, this.rightScreen.getRelativeRight() + 3, this.relativeY + 37));
        this.addChild(new GuiProgress(() -> 0.0, ProgressType.UNINSTALLING, gui, this.rightScreen.getRelativeRight() + 3, this.relativeY + 58));
        this.removeButton = this.addChild(new DigitalButton(gui, this.scrollList.getRelativeRight() + 1, this.relativeY + 54, 56, 12, MekanismLang.UPGRADE_UNINSTALL, (element, mouseX, mouseY) -> {
            if (this.scrollList.hasSelection()) {
                return PacketUtils.sendToServer(new PacketGuiInteract(Screen.hasShiftDown() ? PacketGuiInteract.GuiInteraction.REMOVE_ALL_UPGRADE : PacketGuiInteract.GuiInteraction.REMOVE_UPGRADE, (BlockEntity)this.tile, ((Upgrade)this.scrollList.getSelection()).ordinal()));
            }
            return false;
        })).setTooltip(MekanismLang.UPGRADE_UNINSTALL_TOOLTIP);
        MekanismTileContainer container = (MekanismTileContainer)((GuiMekanism)this.gui()).getMenu();
        this.addChild(new GuiVirtualSlot(this, SlotType.NORMAL, gui, this.rightScreen.getRelativeRight() + 2, this.relativeY + 18, container.getUpgradeSlot()));
        this.addChild(new GuiVirtualSlot(this, SlotType.NORMAL, gui, this.rightScreen.getRelativeRight() + 2, this.relativeY + 72, container.getUpgradeOutputSlot()));
        this.updateEnabledButtons();
        container.startTracking(2, tile.getComponent());
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_TRACK_UPGRADES, (BlockEntity)tile, 2));
    }

    @Override
    public void close() {
        super.close();
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_STOP_TRACKING, (BlockEntity)this.tile, 2));
        ((MekanismContainer)((GuiMekanism)this.gui()).getMenu()).stopTracking(2);
    }

    private void updateEnabledButtons() {
        this.removeButton.active = this.scrollList.hasSelection();
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MekanismLang.UPGRADES.translate(), 5);
        if (this.scrollList.hasSelection()) {
            Upgrade selectedType = (Upgrade)this.scrollList.getSelection();
            int amount = this.tile.getComponent().getUpgrades(selectedType);
            IFancyFontRenderer.WrappedTextRenderer textRenderer = this.upgradeTypeData.get(selectedType);
            if (textRenderer == null) {
                textRenderer = new IFancyFontRenderer.WrappedTextRenderer(this, (Component)MekanismLang.UPGRADE_TYPE.translate(selectedType));
                this.upgradeTypeData.put(selectedType, textRenderer);
            }
            int screenWidth = this.rightScreen.getWidth() - 2;
            int lines = textRenderer.renderWithScale(guiGraphics, this.rightScreen.getRelativeX() + 2, this.rightScreen.getRelativeY() + 2, IFancyFontRenderer.TextAlignment.LEFT, this.screenTextColor(), screenWidth - 2, 0.6f);
            int textY = 4 + 6 * lines;
            this.rightScreen.drawScaledScrollingString(guiGraphics, (Component)MekanismLang.UPGRADE_COUNT.translate(amount, selectedType.getMax()), 0, textY, IFancyFontRenderer.TextAlignment.LEFT, this.screenTextColor(), screenWidth, 2, false, 0.6f, this.msSelected);
            for (Component component : UpgradeUtils.getInfo(this.tile, selectedType)) {
                this.rightScreen.drawScaledScrollingString(guiGraphics, component, 0, textY += 6, IFancyFontRenderer.TextAlignment.LEFT, this.screenTextColor(), screenWidth, 2, false, 0.6f, this.msSelected);
            }
        } else {
            this.noSelection.renderWithScale(guiGraphics, this.rightScreen.getRelativeX() + 2, this.rightScreen.getRelativeY() + 2, IFancyFontRenderer.TextAlignment.LEFT, this.screenTextColor(), 56, 0.8f);
        }
    }
}

