/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.client.model.ModelScubaTank;
import mekanism.client.render.armor.ICustomArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ScubaTankArmor
implements ICustomArmor,
ResourceManagerReloadListener {
    public static final ScubaTankArmor SCUBA_TANK = new ScubaTankArmor();
    private ModelScubaTank model;

    private ScubaTankArmor() {
    }

    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
        this.model = new ModelScubaTank(Minecraft.getInstance().getEntityModels());
    }

    @Override
    public void render(HumanoidModel<? extends LivingEntity> baseModel, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, float partialTicks, boolean hasEffect, LivingEntity entity, ItemStack stack) {
        if (!baseModel.body.visible) {
            return;
        }
        if (baseModel.young) {
            matrix.pushPose();
            float f1 = 1.0f / baseModel.babyBodyScale;
            matrix.scale(f1, f1, f1);
            matrix.translate(0.0, (double)(baseModel.bodyYOffset / 16.0f), 0.0);
            this.renderTank(baseModel, matrix, renderer, light, overlayLight, hasEffect);
            matrix.popPose();
        } else {
            this.renderTank(baseModel, matrix, renderer, light, overlayLight, hasEffect);
        }
    }

    private void renderTank(HumanoidModel<? extends LivingEntity> baseModel, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, boolean hasEffect) {
        matrix.pushPose();
        baseModel.body.translateAndRotate(matrix);
        matrix.translate(0.0, 0.0, 0.06);
        this.model.render(matrix, renderer, light, overlayLight, hasEffect);
        matrix.popPose();
    }
}

