/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.basic.BasicNucleosynthesizingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Nucleosynthesizing")
public class NucleosynthesizingRecipeManager
extends MekanismRecipeManager<SingleItemChemicalRecipeInput, NucleosynthesizingRecipe> {
    public static final NucleosynthesizingRecipeManager INSTANCE = new NucleosynthesizingRecipeManager();

    private NucleosynthesizingRecipeManager() {
        super(MekanismRecipeType.NUCLEOSYNTHESIZING);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack output, int duration, boolean perTickUsage) {
        this.addRecipe(name, this.makeRecipe(itemInput, chemicalInput, output, duration, perTickUsage));
    }

    public final NucleosynthesizingRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack output, int duration, boolean perTickUsage) {
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be a number greater than zero! Duration: " + duration);
        }
        return new BasicNucleosynthesizingRecipe(CrTUtils.fromCrT(itemInput), chemicalInput, this.getAndValidateNotEmpty(output), duration, perTickUsage);
    }

    @Override
    protected String describeOutputs(NucleosynthesizingRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), ItemStackUtil::getCommandString);
    }
}

