/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.api.MethodContext;

public class MethodLabelComparator {
    @Nullable
    public static ComparisonResult findPatchedLabels(AbstractInsnNode cleanInjectionInsn, MethodContext methodContext) {
        List<List<AbstractInsnNode>> patchedLabels;
        List<List<AbstractInsnNode>> cleanLabels = MethodLabelComparator.getLabelsInMethod(methodContext.findCleanInjectionTarget().methodNode());
        List<List<AbstractInsnNode>> cleanLabelsOriginal = List.copyOf(cleanLabels);
        List<List> cleanMatchedLabels = cleanLabels.stream().filter(insns -> insns.contains(cleanInjectionInsn)).toList();
        if (cleanMatchedLabels.size() != 1) {
            return null;
        }
        List cleanLabel = cleanMatchedLabels.getFirst();
        List<List<AbstractInsnNode>> dirtyLabels = MethodLabelComparator.getLabelsInMethod(methodContext.findDirtyInjectionTarget().methodNode());
        List<List<AbstractInsnNode>> dirtyLabelsOriginal = List.copyOf(dirtyLabels);
        LinkedHashMap<List<AbstractInsnNode>, List<AbstractInsnNode>> matchedLabels = new LinkedHashMap<List<AbstractInsnNode>, List<AbstractInsnNode>>();
        for (List<AbstractInsnNode> cleanInsns : cleanLabelsOriginal) {
            ArrayList<List<AbstractInsnNode>> candidates = new ArrayList<List<AbstractInsnNode>>();
            for (List<AbstractInsnNode> dirtyInsns : dirtyLabels) {
                if (!InstructionMatcher.test(cleanInsns, dirtyInsns, 17)) continue;
                candidates.add(dirtyInsns);
            }
            if (candidates.size() != 1) continue;
            List dirtyInsns = (List)candidates.getFirst();
            matchedLabels.put(cleanInsns, dirtyInsns);
            cleanLabels.remove(cleanInsns);
            dirtyLabels.remove(dirtyInsns);
        }
        Pair<List<AbstractInsnNode>, List<AbstractInsnNode>> patchRange = MethodLabelComparator.findPatchHunkRange(cleanLabel, cleanLabelsOriginal, matchedLabels);
        if (patchRange == null) {
            return null;
        }
        int to = dirtyLabelsOriginal.indexOf(patchRange.getSecond());
        if (patchRange.getFirst() == null) {
            patchedLabels = dirtyLabelsOriginal.subList(0, to);
        } else {
            int from = dirtyLabelsOriginal.indexOf(patchRange.getFirst()) + 1;
            if (from < to) {
                patchedLabels = dirtyLabelsOriginal.subList(dirtyLabelsOriginal.indexOf(patchRange.getFirst()) + 1, to);
            } else {
                return null;
            }
        }
        return new ComparisonResult(patchedLabels, cleanLabel);
    }

    @Nullable
    private static @Nullable Pair<@Nullable List<AbstractInsnNode>, List<AbstractInsnNode>> findPatchHunkRange(List<AbstractInsnNode> cleanLabel, List<List<AbstractInsnNode>> cleanLabels, Map<List<AbstractInsnNode>, List<AbstractInsnNode>> matchedLabels) {
        List dirtyLabelBefore;
        int cleanLabelOrdinal = cleanLabels.indexOf(cleanLabel);
        if (cleanLabelOrdinal == 0) {
            dirtyLabelBefore = null;
        } else {
            dirtyLabelBefore = Stream.iterate(cleanLabelOrdinal, i -> i >= 0, i -> i - 1).map(i -> (List)matchedLabels.get(cleanLabels.get((int)i))).filter(Objects::nonNull).findFirst().orElse(null);
            if (dirtyLabelBefore == null) {
                return null;
            }
        }
        List dirtyLabelAfter = Stream.iterate(cleanLabels.indexOf(cleanLabel), i -> i < cleanLabels.size(), i -> i + 1).map(i -> (List)matchedLabels.get(cleanLabels.get((int)i))).filter(Objects::nonNull).findFirst().orElse(null);
        if (dirtyLabelAfter == null) {
            return null;
        }
        return Pair.of((Object)dirtyLabelBefore, (Object)dirtyLabelAfter);
    }

    private static List<List<AbstractInsnNode>> getLabelsInMethod(MethodNode methodNode) {
        ArrayList<List<AbstractInsnNode>> list = new ArrayList<List<AbstractInsnNode>>();
        ArrayList<AbstractInsnNode> workingList = null;
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (insn instanceof FrameNode) continue;
            if (insn instanceof LabelNode) {
                if (workingList != null) {
                    list.add((List<AbstractInsnNode>)workingList);
                }
                workingList = new ArrayList<AbstractInsnNode>();
            }
            workingList.add(insn);
        }
        return list;
    }

    public record ComparisonResult(List<List<AbstractInsnNode>> patchedLabels, List<AbstractInsnNode> cleanLabel) {
    }
}

