/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import java.util.Collection;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.ModifyMixinType;

public class ModifyVarUpgradeToModifyExprVal
implements MethodTransform {
    public static final ModifyVarUpgradeToModifyExprVal INSTANCE = new ModifyVarUpgradeToModifyExprVal();
    private static final Collection<String> ALLOWED_VALUES = Set.of("INVOKE", "INVOKE_ASSIGN");

    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/injection/ModifyVariable;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        AnnotationHandle injectionAnnotation = methodContext.injectionPointAnnotation();
        if (injectionAnnotation == null || injectionAnnotation.getValue("value").filter(v -> ALLOWED_VALUES.contains(v.get())).isEmpty() || injectionAnnotation.getValue("shift").isEmpty() || injectionAnnotation.getValue("by").isEmpty()) {
            return Patch.Result.PASS;
        }
        AnnotationValueHandle target = injectionAnnotation.getValue("target").orElse(null);
        if (target == null) {
            return null;
        }
        ModifyMixinType transform = new ModifyMixinType("Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;", b -> b.sameTarget().injectionPoint("INVOKE", (String)target.get()));
        return transform.apply(classNode, methodNode, methodContext, context);
    }
}

