/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation;

import java.util.Map;
import java.util.function.Consumer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;

public record ModifyMixinType(String replacementDesc, Consumer<Builder> consumer) implements MethodTransform
{
    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        AnnotationHandle annotation = methodContext.methodAnnotation();
        AnnotationNode replacement = new AnnotationNode(this.replacementDesc);
        Builder builder = new Builder(annotation.getAllValues(), replacement);
        this.consumer.accept(builder);
        for (int i = 0; i < methodNode.visibleAnnotations.size(); ++i) {
            AnnotationNode methodAnn = (AnnotationNode)methodNode.visibleAnnotations.get(i);
            if (methodAnn != annotation.unwrap()) continue;
            methodNode.visibleAnnotations.set(i, replacement);
            annotation.refresh(replacement);
            methodContext.recordAudit(this, "Modify type to %s", this.replacementDesc);
            break;
        }
        return Patch.Result.APPLY;
    }

    public static class Builder {
        private final Map<String, AnnotationValueHandle<?>> annotationValues;
        private final AnnotationNode replacement;

        public Builder(Map<String, AnnotationValueHandle<?>> annotationValues, AnnotationNode replacement) {
            this.annotationValues = annotationValues;
            this.replacement = replacement;
        }

        public Builder sameTarget() {
            AnnotationValueHandle<?> method = this.annotationValues.get("method");
            if (method != null) {
                this.putValue("method", method.get());
            }
            return this;
        }

        public Builder putValue(String key, Object value) {
            this.replacement.visit(key, value);
            return this;
        }

        public Builder injectionPoint(String value) {
            return this.injectionPoint(value, "");
        }

        public Builder injectionPoint(String value, String target) {
            return this.injectionPoint(value, target, b -> {});
        }

        public Builder injectionPoint(String value, String target, Consumer<AnnotationVisitor> builder) {
            AnnotationVisitor atNode = this.replacement.visitAnnotation("at", "Lorg/spongepowered/asm/mixin/injection/At;");
            atNode.visit("value", (Object)value);
            if (!target.isEmpty()) {
                atNode.visit("target", (Object)target);
            }
            builder.accept(atNode);
            return this;
        }
    }
}

