/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.sat4j.minisat.core;

import reloc.org.sat4j.minisat.core.ConflictTimerAdapter;
import reloc.org.sat4j.minisat.core.DataStructureFactory;
import reloc.org.sat4j.minisat.core.Solver;

final class LBDConflictTimer
extends ConflictTimerAdapter {
    private static final long serialVersionUID = 1L;
    private int nbconflict = 0;
    private static final int MAX_CLAUSE = 5000;
    private static final int INC_CLAUSE = 1000;
    private int nextbound = 5000;

    LBDConflictTimer(Solver<? extends DataStructureFactory> solver, int bound) {
        super(solver, bound);
    }

    @Override
    public void run() {
        this.nbconflict += this.bound();
        if (this.nbconflict >= this.nextbound) {
            this.nextbound += 1000;
            this.nbconflict = 0;
            this.getSolver().setNeedToReduceDB(true);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.nextbound = 5000;
        if (this.nbconflict >= this.nextbound) {
            this.nbconflict = 0;
            this.getSolver().setNeedToReduceDB(true);
        }
    }

    public String toString() {
        return "check every " + this.bound() + " if the learned constraints reach increasing bounds: " + 5000 + " step " + 1000;
    }
}

