/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import guideme.libs.micromark.ContentType;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.TokenProperty;
import guideme.libs.micromark.TokenizeContext;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Token {
    private static final boolean DEBUG_TOKEN_CREATION = false;
    @Nullable
    private Map<TokenProperty<?>, Object> tokenData;
    public String type;
    public Point start;
    public Point end;
    @Nullable
    public Token previous;
    @Nullable
    public Token next;
    @Nullable
    public ContentType contentType;
    @Nullable
    public TokenizeContext _tokenizer;
    public boolean _open;
    public boolean _close;
    public boolean _isInFirstContentOfListItem;
    public boolean _container;
    public boolean _loose;
    public boolean _inactive;
    public boolean _balanced;
    public StackTraceElement[] stackTrace;

    public Token() {
    }

    public Token(Token other) {
        other.copyTo(this);
    }

    void copyTo(Token other) {
        other.type = this.type;
        other.start = this.start;
        other.end = this.end;
        other.previous = this.previous;
        other.next = this.next;
        other.contentType = this.contentType;
        other._tokenizer = this._tokenizer;
        other._open = this._open;
        other._close = this._close;
        other._isInFirstContentOfListItem = this._isInFirstContentOfListItem;
        other._container = this._container;
        other._loose = this._loose;
        other._inactive = this._inactive;
        other._balanced = this._balanced;
        other.tokenData = this.tokenData;
    }

    @Nullable
    public <T> T get(TokenProperty<T> property) {
        if (this.tokenData == null) {
            return null;
        }
        return (T)this.tokenData.get(property);
    }

    public <T> void set(TokenProperty<T> property, T value) {
        if (this.tokenData == null) {
            this.tokenData = new IdentityHashMap();
        }
        this.tokenData.put(property, value);
    }

    public <T> void remove(TokenProperty<T> property) {
        if (this.tokenData != null) {
            this.tokenData.remove(property);
            if (this.tokenData.isEmpty()) {
                this.tokenData = null;
            }
        }
    }

    public int size() {
        return this.end.offset() - this.start.offset();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Token{").append(this.type);
        if (this.start != null) {
            builder.append(",start=").append(this.start.line()).append(":").append(this.start.column());
        }
        if (this.end != null) {
            builder.append(",end=").append(this.end.line()).append(":").append(this.end.column());
        }
        builder.append("}");
        return builder.toString();
    }
}

