/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SBGui
extends AbstractContainerScreen<SBContainer> {
    private final ResourceLocation GUI;

    public SBGui(SBContainer container, Inventory playerInventory, Component name) {
        super((AbstractContainerMenu)container, playerInventory, name);
        double chance;
        Backpack tier = container.getTier();
        double d = chance = BackpackUtils.increasedAltChance(playerInventory.player.getUUID()) ? 0.01 : 1.0E-4;
        if (tier == Backpack.ULTIMATE && Math.random() < chance) {
            playerInventory.player.playSound(SoundEvents.COW_HURT, 0.5f, 1.0f);
            this.GUI = Math.random() < 0.5 ? ResourceLocation.fromNamespaceAndPath((String)"simplybackpacks", (String)"textures/gui/ultimate_alt.png") : ResourceLocation.fromNamespaceAndPath((String)"simplybackpacks", (String)"textures/gui/ultimate_alt2.png");
        } else {
            this.GUI = tier.texture;
        }
        this.imageWidth = tier.xSize;
        this.imageHeight = tier.ySize;
    }

    protected void init() {
        super.init();
    }

    protected void renderBg(@Nonnull GuiGraphics gg, float partialTicks, int x, int y) {
        gg.blit(this.GUI, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(@Nonnull GuiGraphics gg, int x, int y) {
        gg.drawString(this.font, this.title.getString(), 7, 6, 0x404040, false);
    }

    public void render(@Nonnull GuiGraphics gg, int pMouseX, int pMouseY, float pPartialTicks) {
        super.render(gg, pMouseX, pMouseY, pPartialTicks);
        this.renderTooltip(gg, pMouseX, pMouseY);
    }
}

