/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.inventory;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.items.Backpack;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class BackpackManager
extends SavedData {
    private static final String NAME = "simplybackpacks_backpack_data";
    private static final HashMap<UUID, BackpackData> data = new HashMap();
    public static final BackpackManager blankClient = new BackpackManager();

    public HashMap<UUID, BackpackData> getMap() {
        return data;
    }

    public static BackpackManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (BackpackManager)ServerLifecycleHooks.getCurrentServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(BackpackManager::new, BackpackManager::load), NAME);
        }
        return blankClient;
    }

    public Optional<BackpackData> getBackpack(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public BackpackData getOrCreateBackpack(UUID uuid, Backpack tier) {
        return data.computeIfAbsent(uuid, id -> {
            this.setDirty();
            return new BackpackData((UUID)id, tier);
        });
    }

    public void removeBackpack(UUID uuid) {
        this.getBackpack(uuid).ifPresent(backpack -> {
            data.remove(uuid);
            this.setDirty();
        });
    }

    public IItemHandler getCapability(UUID uuid) {
        if (data.containsKey(uuid)) {
            return data.get(uuid).getHandler();
        }
        return null;
    }

    public IItemHandler getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.has(SimplyBackpacks.BACKPACK_UUID) && data.containsKey(uuid = (UUID)stack.get(SimplyBackpacks.BACKPACK_UUID))) {
            return data.get(uuid).getHandler();
        }
        return null;
    }

    public static BackpackManager load(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        if (nbt.contains("Backpacks")) {
            ListTag list = nbt.getList("Backpacks", 10);
            list.forEach(backpackNBT -> BackpackData.fromNBT((CompoundTag)backpackNBT, pRegistries).ifPresent(backpack -> data.put(backpack.getUuid(), (BackpackData)backpack)));
        }
        return new BackpackManager();
    }

    @Nonnull
    public CompoundTag save(CompoundTag compound, HolderLookup.Provider pRegistries) {
        ListTag backpacks = new ListTag();
        data.forEach((uuid, backpackData) -> backpacks.add((Object)backpackData.toNBT(pRegistries)));
        compound.put("Backpacks", (Tag)backpacks);
        return compound;
    }
}

