/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.CreativeTabOutput;
import dev.architectury.registry.forge.CreativeTabRegistryImpl;
import dev.architectury.registry.registries.DeferredSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

public final class CreativeTabRegistry {
    private CreativeTabRegistry() {
    }

    public static CreativeModeTab create(Component title, Supplier<ItemStack> icon) {
        return CreativeTabRegistry.create(builder -> {
            builder.title(title);
            builder.icon(icon);
        });
    }

    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static CreativeModeTab create(Consumer<CreativeModeTab.Builder> callback) {
        return CreativeTabRegistryImpl.create(callback);
    }

    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static DeferredSupplier<CreativeModeTab> ofBuiltin(CreativeModeTab tab) {
        return CreativeTabRegistryImpl.ofBuiltin(tab);
    }

    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static DeferredSupplier<CreativeModeTab> defer(ResourceLocation name) {
        return CreativeTabRegistryImpl.defer(name);
    }

    @ApiStatus.Experimental
    public static DeferredSupplier<CreativeModeTab> defer(ResourceKey<CreativeModeTab> name) {
        return CreativeTabRegistry.defer(name.location());
    }

    @ApiStatus.Experimental
    public static void modifyBuiltin(CreativeModeTab tab, ModifyTabCallback filler) {
        CreativeTabRegistry.modify(CreativeTabRegistry.ofBuiltin(tab), filler);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static void modify(DeferredSupplier<CreativeModeTab> tab, ModifyTabCallback filler) {
        void var1_1;
        CreativeTabRegistryImpl.modify(tab, (ModifyTabCallback)var1_1);
    }

    @ApiStatus.Experimental
    public static void appendBuiltin(CreativeModeTab tab, ItemLike ... items) {
        CreativeTabRegistry.append(CreativeTabRegistry.ofBuiltin(tab), items);
    }

    @ApiStatus.Experimental
    public static <I extends ItemLike, T extends Supplier<I>> void appendBuiltin(CreativeModeTab tab, T ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.ofBuiltin(tab), Stream.of(items).map(supplier -> () -> CreativeTabRegistry.lambda$appendBuiltin$1((Supplier)supplier)));
    }

    @ApiStatus.Experimental
    public static void appendBuiltinStack(CreativeModeTab tab, ItemStack ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.ofBuiltin(tab), items);
    }

    @ApiStatus.Experimental
    public static void appendBuiltinStack(CreativeModeTab tab, Supplier<ItemStack> ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.ofBuiltin(tab), items);
    }

    @ApiStatus.Experimental
    public static void append(DeferredSupplier<CreativeModeTab> tab, ItemLike ... items) {
        CreativeTabRegistry.appendStack(tab, Stream.of(items).map(item -> () -> new ItemStack(item)));
    }

    @ApiStatus.Experimental
    public static <I extends ItemLike, T extends Supplier<I>> void append(DeferredSupplier<CreativeModeTab> tab, T ... items) {
        CreativeTabRegistry.appendStack(tab, Stream.of(items).map(supplier -> () -> CreativeTabRegistry.lambda$append$5((Supplier)supplier)));
    }

    @ApiStatus.Experimental
    public static void appendStack(DeferredSupplier<CreativeModeTab> tab, ItemStack ... items) {
        CreativeTabRegistry.appendStack(tab, Stream.of(items).map(supplier -> () -> supplier));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Experimental
    @ExpectPlatform.Transformed
    public static void appendStack(DeferredSupplier<CreativeModeTab> tab, Supplier<ItemStack> item) {
        void var1_1;
        CreativeTabRegistryImpl.appendStack(tab, (Supplier<ItemStack>)var1_1);
    }

    @ApiStatus.Experimental
    public static void appendStack(DeferredSupplier<CreativeModeTab> tab, Supplier<ItemStack> ... items) {
        for (Supplier<ItemStack> item : items) {
            CreativeTabRegistry.appendStack(tab, item);
        }
    }

    @ApiStatus.Experimental
    public static void appendStack(DeferredSupplier<CreativeModeTab> tab, Stream<Supplier<ItemStack>> items) {
        items.forEach(item -> CreativeTabRegistry.appendStack(tab, (Supplier<ItemStack>)item));
    }

    @ApiStatus.Experimental
    public static void append(ResourceKey<CreativeModeTab> tab, ItemLike ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.defer(tab), Stream.of(items).map(item -> () -> new ItemStack(item)));
    }

    @ApiStatus.Experimental
    public static <I extends ItemLike, T extends Supplier<I>> void append(ResourceKey<CreativeModeTab> tab, T ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.defer(tab), Stream.of(items).map(supplier -> () -> CreativeTabRegistry.lambda$append$12((Supplier)supplier)));
    }

    @ApiStatus.Experimental
    public static void appendStack(ResourceKey<CreativeModeTab> tab, ItemStack ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.defer(tab), Stream.of(items).map(supplier -> () -> supplier));
    }

    @ApiStatus.Experimental
    public static void appendStack(ResourceKey<CreativeModeTab> tab, Supplier<ItemStack> item) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.defer(tab), item);
    }

    @ApiStatus.Experimental
    public static void appendStack(ResourceKey<CreativeModeTab> tab, Supplier<ItemStack> ... items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.defer(tab), items);
    }

    @ApiStatus.Experimental
    public static void appendStack(ResourceKey<CreativeModeTab> tab, Stream<Supplier<ItemStack>> items) {
        CreativeTabRegistry.appendStack(CreativeTabRegistry.defer(tab), items);
    }

    private static /* synthetic */ ItemStack lambda$append$12(Supplier supplier) {
        return new ItemStack((ItemLike)supplier.get());
    }

    private static /* synthetic */ ItemStack lambda$append$5(Supplier supplier) {
        return new ItemStack((ItemLike)supplier.get());
    }

    private static /* synthetic */ ItemStack lambda$appendBuiltin$1(Supplier supplier) {
        return new ItemStack((ItemLike)supplier.get());
    }

    @FunctionalInterface
    public static interface ModifyTabCallback {
        public void accept(FeatureFlagSet var1, CreativeTabOutput var2, boolean var3);
    }
}

