/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.oreharvester_common_forge.processing;

import com.natamus.collective_common_forge.services.Services;
import com.natamus.oreharvester_common_forge.data.Constants;
import com.natamus.oreharvester_common_forge.data.Variables;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PickaxeBlacklist {
    public static void attemptProcessingPickaxeBlacklist(Level level) {
        if (!Variables.processedPickaxeBlacklist) {
            try {
                PickaxeBlacklist.setupPickaxeBlacklist(level);
                Variables.processedPickaxeBlacklist = true;
            }
            catch (IOException ex) {
                Constants.logger.warn("[Ore Harvester] Something went wrong setting up the pickaxe blacklist file.");
            }
        }
    }

    public static void setupPickaxeBlacklist(Level level) throws IOException {
        Registry itemRegistry = level.registryAccess().registryOrThrow(Registries.ITEM);
        ArrayList<String> blacklist = new ArrayList<String>();
        PrintWriter writer = null;
        if (!Constants.configDir.isDirectory() || !Constants.blacklistFile.isFile()) {
            boolean ignored = Constants.configDir.mkdirs();
            writer = new PrintWriter(Constants.configPath + File.separator + "harvestable_pickaxe_blacklist.txt", StandardCharsets.UTF_8);
        } else {
            String blcontent = new String(Files.readAllBytes(Paths.get(Constants.configPath + File.separator + "harvestable_pickaxe_blacklist.txt", new String[0])));
            for (String pickaxerl : blcontent.split(",")) {
                String name = pickaxerl.replace("\n", "").trim();
                if (name.startsWith("//") || !name.startsWith("!")) continue;
                blacklist.add(name.replace("!", ""));
            }
        }
        if (writer != null) {
            writer.println("// To disable a certain pickaxe from being able to harvest ore veins, add an exclamation mark (!) in front of the line,");
        }
        for (Item item : itemRegistry) {
            ResourceLocation rl;
            if (!Services.TOOLFUNCTIONS.isPickaxe(new ItemStack((ItemLike)item)) || (rl = itemRegistry.getKey((Object)item)) == null) continue;
            String name = rl.toString();
            if (writer != null) {
                writer.println(name + ",");
            }
            if (blacklist.contains(name)) continue;
            Variables.allowedPickaxes.add(item);
        }
        if (writer != null) {
            writer.close();
        }
    }
}

