/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.TooltipButton;

public class ScreenSwitchSettingEntry
implements ISettingEntry {
    private String name;
    private BiFunction<Screen, Screen, Screen> screenFactory;
    private Supplier<CursorBox> tooltipSupplier;
    private boolean active;

    public ScreenSwitchSettingEntry(String name, BiFunction<Screen, Screen, Screen> screenFactoryFromCurrentAndEscape, CursorBox tooltip, boolean active) {
        this.name = name;
        this.screenFactory = screenFactoryFromCurrentAndEscape;
        this.tooltipSupplier = () -> tooltip;
        this.active = active;
    }

    @Override
    public String getStringForSearch() {
        CursorBox entryTooltip = this.tooltipSupplier == null ? null : this.tooltipSupplier.get();
        return I18n.get((String)this.name, (Object[])new Object[0]) + " " + this.name.replace("gui.xaero", "") + (String)(entryTooltip != null ? " " + entryTooltip.getFullCode().replace("gui.xaero", "") + " " + I18n.get((String)entryTooltip.getFullCode(), (Object[])new Object[0]) : "");
    }

    @Override
    public AbstractWidget createWidget(int x, int y, int w, boolean canEditIngameSettings) {
        TooltipButton button = new TooltipButton(x, y, w, 20, (Component)Component.translatable((String)this.name), b -> {
            Minecraft mc = Minecraft.getInstance();
            Screen current = mc.screen;
            Screen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
            Screen targetScreen = this.screenFactory.apply(current, currentEscScreen);
            if (current instanceof ScreenBase) {
                ((ScreenBase)current).onExit(targetScreen);
            } else {
                mc.setScreen(targetScreen);
            }
        }, this.tooltipSupplier);
        button.active = this.active;
        return button;
    }

    public BiFunction<Screen, Screen, Screen> getScreenFactory() {
        return this.screenFactory;
    }
}

