/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.function.LongSupplier;
import mekanism.api.IEvaporationSolar;
import mekanism.api.RelativeSide;
import mekanism.api.math.MathUtils;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityAdvancedSolarGenerator
extends TileEntitySolarGenerator
implements IBoundingBlock,
IEvaporationSolar {
    private static final RelativeSide[] ENERGY_SIDES = new RelativeSide[]{RelativeSide.FRONT, RelativeSide.BOTTOM};
    private final TileEntitySolarGenerator.SolarCheck[] solarChecks = new TileEntitySolarGenerator.SolarCheck[8];

    public TileEntityAdvancedSolarGenerator(BlockPos pos, BlockState state) {
        super((Holder<Block>)GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR, pos, state, (LongSupplier)MekanismGeneratorsConfig.generators.advancedSolarGeneration);
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return ENERGY_SIDES;
    }

    @Override
    protected long getConfiguredMax() {
        return MekanismGeneratorsConfig.generators.advancedSolarGeneration.get();
    }

    @Override
    protected void recheckSettings() {
        if (this.level == null) {
            return;
        }
        BlockPos topPos = this.worldPosition.above(2);
        this.solarCheck = new AdvancedSolarCheck(this.level, topPos);
        float totalPeak = this.solarCheck.getPeakMultiplier();
        for (int i = 0; i < this.solarChecks.length; ++i) {
            this.solarChecks[i] = i < 3 ? new AdvancedSolarCheck(this.level, topPos.offset(-1, 0, i - 1)) : (i == 3 ? new AdvancedSolarCheck(this.level, topPos.offset(0, 0, -1)) : (i == 4 ? new AdvancedSolarCheck(this.level, topPos.offset(0, 0, 1)) : new AdvancedSolarCheck(this.level, topPos.offset(1, 0, i - 6))));
            totalPeak += this.solarChecks[i].getPeakMultiplier();
        }
        this.updateMaxOutputRaw(MathUtils.clampToLong((double)((float)this.getConfiguredMax() * (totalPeak / 9.0f))));
    }

    @Override
    protected boolean checkCanSeeSun() {
        if (this.solarCheck == null) {
            return false;
        }
        this.solarCheck.recheckCanSeeSun();
        int count = this.solarCheck.canSeeSun() ? 1 : 0;
        for (TileEntitySolarGenerator.SolarCheck check : this.solarChecks) {
            check.recheckCanSeeSun();
            if (!check.canSeeSun()) continue;
            count = (byte)(count + 1);
        }
        return count > 4;
    }

    @Override
    public long getProduction() {
        if (this.level == null || this.solarCheck == null) {
            return 0L;
        }
        float brightness = this.getBrightnessMultiplier(this.level);
        float generationMultiplier = this.solarCheck.getGenerationMultiplier();
        for (TileEntitySolarGenerator.SolarCheck check : this.solarChecks) {
            generationMultiplier += check.getGenerationMultiplier();
        }
        return MathUtils.clampToLong((double)((float)this.getConfiguredMax() * (brightness * (generationMultiplier /= (float)(this.solarChecks.length + 1)))));
    }

    private static class AdvancedSolarCheck
    extends TileEntitySolarGenerator.SolarCheck {
        private final int recheckFrequency;
        private long lastCheckedSun;

        public AdvancedSolarCheck(Level world, BlockPos pos) {
            super(world, pos);
            this.recheckFrequency = Mth.nextInt((RandomSource)world.random, (int)10, (int)30);
        }

        @Override
        public void recheckCanSeeSun() {
            BlockState state;
            BlockPos above;
            if (!this.world.dimensionType().hasSkyLight() || this.world.getSkyDarken() >= 4) {
                this.canSeeSun = false;
                return;
            }
            long time = this.world.getGameTime();
            if (time < this.lastCheckedSun + (long)this.recheckFrequency) {
                return;
            }
            this.lastCheckedSun = time;
            this.canSeeSun = this.world.getFluidState(this.pos).isEmpty() ? this.world.canSeeSky(this.pos) : (this.world.canSeeSky(above = this.pos.above()) ? !(state = this.world.getBlockState(above)).liquid() && state.getLightBlock((BlockGetter)this.world, above) <= 0 : false);
        }
    }
}

