/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks;

import com.flanks255.simplybackpacks.commands.SBCommands;
import com.flanks255.simplybackpacks.configuration.CommonConfiguration;
import com.flanks255.simplybackpacks.configuration.ConfigCache;
import com.flanks255.simplybackpacks.crafting.CopyBackpackDataRecipe;
import com.flanks255.simplybackpacks.data.Generator;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.FilterGui;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.gui.SBGui;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.network.HotkeyPacket;
import com.flanks255.simplybackpacks.network.SBNetwork;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import com.flanks255.simplybackpacks.util.RecipeUnlocker;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod(value="simplybackpacks")
public class SimplyBackpacks {
    public static final String MODID = "simplybackpacks";
    public static final Logger LOGGER = LogManager.getLogger((String)"simplybackpacks");
    public static final TagKey<Item> HOLDS_ITEMS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"holds_items"));
    public static final TagKey<Item> CURIOS_BACK = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"back"));
    public static final TagKey<Enchantment> SOULBOUND = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"soulbound"));
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"simplybackpacks");
    private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"simplybackpacks");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"simplybackpacks");
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> COPYRECIPE = RECIPES.register("backpack_upgrade", CopyBackpackDataRecipe.Serializer::new);
    public static final DeferredHolder<MenuType<?>, MenuType<SBContainer>> SBCONTAINER = CONTAINERS.register("sb_container", () -> IMenuTypeExtension.create(SBContainer::fromNetwork));
    public static final DeferredHolder<MenuType<?>, MenuType<FilterContainer>> FILTERCONTAINER = CONTAINERS.register("filter_container", () -> IMenuTypeExtension.create(FilterContainer::fromNetwork));
    public static final DeferredItem<Item> COMMONBACKPACK = ITEMS.register("commonbackpack", () -> new BackpackItem("commonbackpack", Backpack.COMMON));
    public static final DeferredItem<Item> UNCOMMONBACKPACK = ITEMS.register("uncommonbackpack", () -> new BackpackItem("uncommonbackpack", Backpack.UNCOMMON));
    public static final DeferredItem<Item> RAREBACKPACK = ITEMS.register("rarebackpack", () -> new BackpackItem("rarebackpack", Backpack.RARE));
    public static final DeferredItem<Item> EPICBACKPACK = ITEMS.register("epicbackpack", () -> new BackpackItem("epicbackpack", Backpack.EPIC));
    public static final DeferredItem<Item> ULTIMATEBACKPACK = ITEMS.register("ultimatebackpack", () -> new BackpackItem("ultimatebackpack", Backpack.ULTIMATE));
    private final NonNullList<KeyMapping> keyBinds = NonNullList.create();
    public static final DeferredRegister<DataComponentType<?>> COMPONENTS = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"simplybackpacks");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<UUID>> BACKPACK_UUID = COMPONENTS.register("backpack_uuid", () -> DataComponentType.builder().persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> BACKPACK_PICKUP = COMPONENTS.register("backpack_pickup", () -> DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> BACKPACK_FILTER = COMPONENTS.register("backpack_filter", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());

    public SimplyBackpacks(IEventBus bus, ModContainer container, Dist dist) {
        IEventBus neoBus = NeoForge.EVENT_BUS;
        ITEMS.register(bus);
        CONTAINERS.register(bus);
        RECIPES.register(bus);
        COMPONENTS.register(bus);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfiguration.COMMON_CONFIG);
        bus.addListener(ConfigCache::listen);
        neoBus.addListener(SBCommands::listen);
        bus.addListener(this::registerCaps);
        bus.addListener(SBNetwork::register);
        bus.addListener(this::setup);
        if (dist == Dist.CLIENT) {
            bus.addListener(this::menuScreenEvent);
            bus.addListener(this::registerKeyBinding);
            neoBus.addListener(this::onClientTick);
            bus.addListener(this::creativeTabEvent);
        }
        bus.addListener(Generator::gatherData);
        neoBus.addListener(this::pickupEvent);
        BackpackUtils.curiosLoaded = ModList.get().isLoaded("curios");
        RecipeUnlocker.register(MODID, neoBus, 2);
    }

    public void setup(FMLCommonSetupEvent event) {
    }

    private void pickupEvent(ItemEntityPickupEvent.Pre event) {
        ItemStack stack;
        Optional slotResult;
        Optional curiosInventory;
        if (event.getPlayer().containerMenu instanceof SBContainer || event.getPlayer().isCrouching() || event.getItemEntity().getItem().getItem() instanceof BackpackItem) {
            return;
        }
        if (event.getItemEntity().hasPickUpDelay()) {
            return;
        }
        if (BackpackUtils.curiosLoaded && (curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)event.getPlayer())).isPresent() && (slotResult = ((ICuriosItemHandler)curiosInventory.get()).findFirstCurio(BackpackItem::isBackpack)).isPresent() && BackpackItem.pickupEvent(event, stack = ((SlotResult)slotResult.get()).stack())) {
            return;
        }
        Inventory playerInv = event.getPlayer().getInventory();
        for (int i = 0; i <= 8; ++i) {
            stack = playerInv.getItem(i);
            if (!(stack.getItem() instanceof BackpackItem) || !BackpackItem.pickupEvent(event, stack)) continue;
            event.setCanPickup(TriState.TRUE);
            return;
        }
    }

    private void onClientTick(ClientTickEvent.Post event) {
        if (((KeyMapping)this.keyBinds.get(0)).consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new HotkeyPacket(HotkeyPacket.HotKey.TOGGLE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (((KeyMapping)this.keyBinds.get(1)).consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new HotkeyPacket(HotkeyPacket.HotKey.OPEN), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void registerKeyBinding(RegisterKeyMappingsEvent event) {
        this.keyBinds.add(0, (Object)new KeyMapping("key.simplybackpacks.backpackpickup.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "key.simplybackpacks.category"));
        this.keyBinds.add(1, (Object)new KeyMapping("key.simplybackpacks.backpackopen.desc", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "key.simplybackpacks.category"));
        event.register((KeyMapping)this.keyBinds.get(0));
        event.register((KeyMapping)this.keyBinds.get(1));
    }

    private void creativeTabEvent(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().compareTo(CreativeModeTabs.TOOLS_AND_UTILITIES) == 0) {
            event.accept((ItemLike)COMMONBACKPACK.get());
            event.accept((ItemLike)UNCOMMONBACKPACK.get());
            event.accept((ItemLike)RAREBACKPACK.get());
            event.accept((ItemLike)EPICBACKPACK.get());
            event.accept((ItemLike)ULTIMATEBACKPACK.get());
        }
    }

    private void menuScreenEvent(RegisterMenuScreensEvent event) {
        event.register((MenuType)SBCONTAINER.get(), SBGui::new);
        event.register((MenuType)FILTERCONTAINER.get(), FilterGui::new);
    }

    private void registerCaps(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, ctx) -> BackpackManager.get().getCapability((ItemStack)stack), new ItemLike[]{COMMONBACKPACK, UNCOMMONBACKPACK, RAREBACKPACK, EPICBACKPACK, ULTIMATEBACKPACK});
    }

    private static void renderPlayer(RenderPlayerEvent.Post event) {
    }
}

