/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.MethodUpgrader;
import org.sinytra.adapter.patch.util.MethodQualifier;

public record ModifyInjectionTarget(List<String> replacementMethods, Action action) implements MethodTransform
{
    public static final Codec<ModifyInjectionTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("replacementMethods").forGetter(ModifyInjectionTarget::replacementMethods), (App)Action.CODEC.optionalFieldOf("action", (Object)Action.OVERWRITE).forGetter(ModifyInjectionTarget::action)).apply((Applicative)instance, ModifyInjectionTarget::new));

    public ModifyInjectionTarget(List<String> replacementMethods) {
        this(replacementMethods, Action.OVERWRITE);
    }

    @Override
    public Codec<? extends MethodTransform> codec() {
        return CODEC;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        AnnotationHandle annotation = methodContext.methodAnnotation();
        methodContext.recordAudit(this, "Change mixin target to %s", this.replacementMethods);
        if (annotation.matchesDesc("Lorg/spongepowered/asm/mixin/Overwrite;")) {
            if (this.replacementMethods.size() > 1) {
                throw new IllegalStateException("Cannot determine replacement @Overwrite method name, multiple specified: " + String.valueOf(this.replacementMethods));
            }
            String replacement = this.replacementMethods.getFirst();
            MethodQualifier.create(replacement).map(MethodQualifier::name).ifPresent(str -> {
                methodNode.name = str;
            });
        } else {
            annotation.getValue("method").ifPresentOrElse(handle -> {
                List original = (List)handle.get();
                this.action.handler.apply((AnnotationValueHandle<List<String>>)handle, methodContext.matchingTargets(), this.replacementMethods);
                if (original.size() == 1 && ((List)handle.get()).size() == 1) {
                    MethodUpgrader.upgradeMethod(methodNode, methodContext, (String)original.getFirst(), (String)((List)handle.get()).getFirst());
                }
            }, () -> annotation.appendValue("method", this.replacementMethods));
        }
        if (methodContext.capturesLocals()) {
            MethodUpgrader.upgradeCapturedLocals(methodNode, methodContext);
        }
        return Patch.Result.APPLY;
    }

    public static enum Action {
        ADD((handle, targets, replacements) -> ((List)handle.get()).addAll(replacements)),
        REPLACE((handle, targets, replacements) -> {
            List value = (List)handle.get();
            value.removeAll(targets);
            value.addAll(replacements);
        }),
        OVERWRITE((handle, targets, replacements) -> handle.set(replacements));

        private static final Codec<Action> CODEC;
        private final TargetHandler handler;

        private Action(TargetHandler handler) {
            this.handler = handler;
        }

        static {
            CODEC = Codec.STRING.xmap(Action::valueOf, Enum::name);
        }
    }

    public static interface TargetHandler {
        public void apply(AnnotationValueHandle<List<String>> var1, List<String> var2, List<String> var3);
    }
}

