/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.gui.element.window.filter.GuiFilter;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class GuiFilterSelect<TILE extends TileEntityMekanism>
extends GuiWindow {
    private static final int FILTER_HEIGHT = 20;
    protected final TILE tile;

    protected GuiFilterSelect(IGuiWrapper gui, TILE tile, int filterCount) {
        super(gui, (gui.getXSize() - 152) / 2, 20, 152, 30 + filterCount * 20, SelectedWindowData.UNSPECIFIED);
        this.tile = tile;
        this.addChild(new GuiElementHolder(gui, this.relativeX + 11, this.relativeY + 18, 130, 2 + filterCount * 20));
        int buttonY = this.relativeY + 19;
        buttonY = this.addFilterButton(buttonY, MekanismLang.BUTTON_ITEMSTACK_FILTER, this.getItemStackFilterCreator());
        buttonY = this.addFilterButton(buttonY, MekanismLang.BUTTON_TAG_FILTER, this.getTagFilterCreator());
        this.addFilterButton(buttonY, MekanismLang.BUTTON_MODID_FILTER, this.getModIDFilterCreator());
    }

    private int addFilterButton(int buttonY, ILangEntry translationHelper, @Nullable GuiFilterCreator<TILE> filterSupplier) {
        if (filterSupplier == null) {
            return buttonY;
        }
        this.addChild(new TranslationButton(this.gui(), this.relativeX + 12, buttonY, 128, 20, translationHelper, (element, mouseX, mouseY) -> {
            IGuiWrapper gui = element.gui();
            gui.addWindow(filterSupplier.create(gui, this.tile));
            return this.close(element, mouseX, mouseY);
        }));
        return buttonY + 20;
    }

    @Nullable
    protected GuiFilterCreator<TILE> getItemStackFilterCreator() {
        return null;
    }

    @Nullable
    protected GuiFilterCreator<TILE> getTagFilterCreator() {
        return null;
    }

    @Nullable
    protected GuiFilterCreator<TILE> getModIDFilterCreator() {
        return null;
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MekanismLang.CREATE_FILTER_TITLE.translate(), 6);
    }

    @FunctionalInterface
    protected static interface GuiFilterCreator<TILE extends TileEntityMekanism> {
        public GuiFilter<?, ?> create(IGuiWrapper var1, TILE var2);
    }
}

