/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command.builders;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.function.Predicate;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildCommand {
    private static final SimpleCommandExceptionType MISS = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_BUILD_MISS.translate());
    public static final ArgumentBuilder<CommandSourceStack, ?> COMMAND = ((LiteralArgumentBuilder)Commands.literal((String)"build").requires(MekanismPermissions.COMMAND_BUILD.and(cs -> cs.getEntity() instanceof ServerPlayer))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires((Predicate)MekanismPermissions.COMMAND_BUILD_REMOVE)).executes(ctx -> {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        BuildCommand.destroy((Level)source.getLevel(), BuildCommand.rayTracePos(source));
        source.sendSuccess(() -> MekanismLang.COMMAND_BUILD_REMOVED.translateColored(EnumColor.GRAY), true);
        return 1;
    }));

    private BuildCommand() {
    }

    public static void register(String name, ILangEntry localizedName, StructureBuilder builder) {
        COMMAND.then(BuildCommand.registerSub(Commands.literal((String)name).then(BuildCommand.registerSub(Commands.literal((String)"empty"), localizedName, builder, true)), localizedName, builder, false));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> registerSub(ArgumentBuilder<CommandSourceStack, ?> argumentBuilder, ILangEntry localizedName, StructureBuilder builder, boolean empty) {
        return argumentBuilder.executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            BlockPos pos = BuildCommand.rayTracePos(source).relative(Direction.UP);
            return BuildCommand.build((CommandContext<CommandSourceStack>)ctx, localizedName, builder, pos, empty);
        }).then(Commands.argument((String)"start", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> BuildCommand.build((CommandContext<CommandSourceStack>)ctx, localizedName, builder, BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"start"), empty)));
    }

    private static BlockPos rayTracePos(CommandSourceStack source) throws CommandSyntaxException {
        BlockHitResult result = MekanismUtils.rayTrace((Player)source.getPlayerOrException(), 100.0);
        if (result.getType() == HitResult.Type.MISS) {
            throw MISS.create();
        }
        return result.getBlockPos();
    }

    private static int build(CommandContext<CommandSourceStack> ctx, ILangEntry localizedName, StructureBuilder builder, BlockPos start, boolean empty) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        builder.build((Level)source.getLevel(), start, empty);
        source.sendSuccess(() -> {
            MekanismLang builtEntry = empty ? MekanismLang.COMMAND_BUILD_BUILT_EMPTY : MekanismLang.COMMAND_BUILD_BUILT;
            return builtEntry.translateColored(EnumColor.GRAY, EnumColor.INDIGO, localizedName);
        }, true);
        return 1;
    }

    private static void destroy(Level world, BlockPos pos) throws CommandSyntaxException {
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        if (!BuildCommand.isMekanismBlock((LevelAccessor)world, (Long2ObjectMap<ChunkAccess>)chunkMap, pos)) {
            throw MISS.create();
        }
        HashSet<BlockPos> traversed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> openSet = new ArrayDeque<BlockPos>();
        openSet.add(pos);
        traversed.add(pos);
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.poll();
            if (!BuildCommand.isMekanismBlock((LevelAccessor)world, (Long2ObjectMap<ChunkAccess>)chunkMap, ptr)) continue;
            Clearable.tryClear((Object)WorldUtils.getTileEntity((LevelAccessor)world, (Long2ObjectMap<ChunkAccess>)chunkMap, ptr));
            world.setBlock(ptr, world.getFluidState(ptr).createLegacyBlock(), 35);
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos offset = ptr.relative(side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }

    private static boolean isMekanismBlock(@Nullable LevelAccessor world, @NotNull Long2ObjectMap<ChunkAccess> chunkMap, @NotNull BlockPos pos) {
        return WorldUtils.getBlockState(world, chunkMap, pos).map(state -> state.getBlockHolder().getKey()).filter(key -> key.location().getNamespace().startsWith("mekanism")).isPresent();
    }
}

