/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.lib.collection.BiLongMultimap;
import mekanism.common.lib.collection.FilterTransformIterator;
import mekanism.common.util.ChunkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@NothingNullByDefault
public class IndexedCuboidMap<VALUE> {
    private final BiLongMultimap<CenteredBoundingBox> chunkIndex = new BiLongMultimap();
    private final Map<CenteredBoundingBox, VALUE> valueMap = new HashMap<CenteredBoundingBox, VALUE>();

    public void track(VALUE value, BlockPos center, int blockRadius) {
        this.track(value, center, center.getX() - blockRadius, center.getY() - blockRadius, center.getZ() - blockRadius, center.getX() + blockRadius, center.getY() + blockRadius, center.getZ() + blockRadius);
    }

    public void track(VALUE value, BlockPos center, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        CenteredBoundingBox box = new CenteredBoundingBox(center.asLong(), minX, minY, minZ, maxX, maxY, maxZ);
        if (!box.isInside((Vec3i)center)) {
            throw new IllegalArgumentException("center must be within the box");
        }
        VALUE previous = this.valueMap.put(box, value);
        if (previous != null) {
            return;
        }
        int minChunkX = SectionPos.blockToSectionCoord((int)box.minX());
        int minChunkZ = SectionPos.blockToSectionCoord((int)box.minZ());
        int maxChunkX = SectionPos.blockToSectionCoord((int)box.maxX());
        int maxChunkZ = SectionPos.blockToSectionCoord((int)box.maxZ());
        if (minChunkX == maxChunkX && minChunkZ == maxChunkZ) {
            this.chunkIndex.put(ChunkPos.asLong((int)minChunkX, (int)minChunkZ), box);
        } else {
            this.chunkIndex.putAll(ChunkUtils.rangeClosed(minChunkX, minChunkZ, maxChunkX, maxChunkZ), box);
        }
    }

    public void remove(VALUE value) {
        ArrayList<CenteredBoundingBox> toRemove = new ArrayList<CenteredBoundingBox>(this.valueMap.size());
        for (Map.Entry<CenteredBoundingBox, VALUE> valueEntry : this.valueMap.entrySet()) {
            if (!valueEntry.getValue().equals(value)) continue;
            toRemove.add(valueEntry.getKey());
        }
        for (CenteredBoundingBox box : toRemove) {
            this.valueMap.remove(box);
            this.chunkIndex.removeValue(box);
        }
    }

    public boolean removeAt(BlockPos center) {
        if (this.valueMap.isEmpty()) {
            return false;
        }
        long centerAsLong = center.asLong();
        ArrayList<CenteredBoundingBox> toRemove = new ArrayList<CenteredBoundingBox>(this.valueMap.size());
        for (Map.Entry<CenteredBoundingBox, VALUE> valueEntry : this.valueMap.entrySet()) {
            if (valueEntry.getKey().center != centerAsLong) continue;
            toRemove.add(valueEntry.getKey());
        }
        for (CenteredBoundingBox box : toRemove) {
            this.valueMap.remove(box);
            this.chunkIndex.removeValue(box);
        }
        return !toRemove.isEmpty();
    }

    public Iterator<VALUE> find(final BlockPos searchPos) {
        Set<CenteredBoundingBox> values = this.chunkIndex.getValues(ChunkPos.asLong((BlockPos)searchPos));
        if (values == null) {
            return Collections.emptyIterator();
        }
        return new FilterTransformIterator<CenteredBoundingBox, VALUE>(values.iterator()){

            @Override
            @Nullable
            protected VALUE filterTransform(CenteredBoundingBox box) {
                if (box.isInside((Vec3i)searchPos)) {
                    return IndexedCuboidMap.this.valueMap.get(box);
                }
                return null;
            }
        };
    }

    @Nullable
    public VALUE findFirstAt(BlockPos centre) {
        Set<CenteredBoundingBox> values = this.chunkIndex.getValues(ChunkPos.asLong((BlockPos)centre));
        if (values == null) {
            return null;
        }
        long centerAsLong = centre.asLong();
        for (CenteredBoundingBox box : values) {
            if (centerAsLong != box.center) continue;
            return Objects.requireNonNull(this.valueMap.get(box), "Box existed with no value??");
        }
        return null;
    }

    public Iterator<VALUE> allCenteredInChunk(int chunkX, int chunkZ) {
        return this.allCenteredInChunk(ChunkPos.asLong((int)chunkX, (int)chunkZ));
    }

    public Iterator<VALUE> allCenteredInChunk(final long chunkPos) {
        Set<CenteredBoundingBox> values = this.chunkIndex.getValues(chunkPos);
        if (values == null) {
            return Collections.emptyIterator();
        }
        return new FilterTransformIterator<CenteredBoundingBox, VALUE>(values.iterator()){

            @Override
            @Nullable
            protected VALUE filterTransform(CenteredBoundingBox box) {
                if (ChunkUtils.packedBlockToChunk(box.center) == chunkPos) {
                    return IndexedCuboidMap.this.valueMap.get(box);
                }
                return null;
            }
        };
    }

    public Collection<VALUE> values() {
        return this.valueMap.values();
    }

    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    @VisibleForTesting
    boolean indexIsEmpty() {
        return this.chunkIndex.isEmpty();
    }

    public void removeIf(Predicate<VALUE> predicate) {
        Iterator<Map.Entry<CenteredBoundingBox, VALUE>> iterator = this.valueMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CenteredBoundingBox, VALUE> entry = iterator.next();
            if (!predicate.test(entry.getValue())) continue;
            iterator.remove();
            this.chunkIndex.removeValue(entry.getKey());
        }
    }

    public void clear() {
        this.valueMap.clear();
        this.chunkIndex.clear();
    }

    private record CenteredBoundingBox(long center, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        public boolean isInside(Vec3i vector) {
            return this.isInside(vector.getX(), vector.getY(), vector.getZ());
        }

        public boolean isInside(int x, int y, int z) {
            return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ && y >= this.minY && y <= this.maxY;
        }

        @Override
        public String toString() {
            return "CenteredBoundingBox{center=[" + BlockPos.getX((long)this.center) + ", " + BlockPos.getY((long)this.center) + ", " + BlockPos.getZ((long)this.center) + "], minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + "}";
        }
    }
}

