/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.APILang;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

@NothingNullByDefault
public enum RelativeSide implements IHasTranslationKey.IHasEnumNameTranslationKey,
StringRepresentable
{
    FRONT(APILang.FRONT),
    LEFT(APILang.LEFT),
    RIGHT(APILang.RIGHT),
    BACK(APILang.BACK),
    TOP(APILang.TOP),
    BOTTOM(APILang.BOTTOM);

    public static final Codec<RelativeSide> CODEC;
    public static final IntFunction<RelativeSide> BY_ID;
    public static final StreamCodec<ByteBuf, RelativeSide> STREAM_CODEC;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final ILangEntry langEntry;

    private RelativeSide(ILangEntry langEntry) {
        this.langEntry = langEntry;
    }

    @Override
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    public Direction getDirection(Direction facing) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> facing;
            case 3 -> facing.getOpposite();
            case 1 -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.EAST;
                }
                yield facing.getClockWise();
            }
            case 2 -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.WEST;
                }
                yield facing.getCounterClockWise();
            }
            case 4 -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.NORTH;
                    }
                    case UP: {
                        yield Direction.SOUTH;
                    }
                }
                yield Direction.UP;
            }
            case 5 -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                    case UP: {
                        yield Direction.NORTH;
                    }
                }
                yield Direction.DOWN;
            }
        };
    }

    public static RelativeSide fromDirections(Direction facing, Direction side) {
        if (side == facing) {
            return FRONT;
        }
        if (side == facing.getOpposite()) {
            return BACK;
        }
        if (facing == Direction.DOWN || facing == Direction.UP) {
            return switch (side) {
                case Direction.NORTH -> {
                    if (facing == Direction.DOWN) {
                        yield TOP;
                    }
                    yield BOTTOM;
                }
                case Direction.SOUTH -> {
                    if (facing == Direction.DOWN) {
                        yield BOTTOM;
                    }
                    yield TOP;
                }
                case Direction.WEST -> RIGHT;
                case Direction.EAST -> LEFT;
                default -> throw new IllegalStateException("Case should have been caught earlier.");
            };
        }
        if (side == Direction.DOWN) {
            return BOTTOM;
        }
        if (side == Direction.UP) {
            return TOP;
        }
        if (side == facing.getCounterClockWise()) {
            return RIGHT;
        }
        if (side == facing.getClockWise()) {
            return LEFT;
        }
        return FRONT;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(RelativeSide::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])RelativeSide.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

