/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.BasicColorButton;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.MekClickType;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SideDataButton
extends BasicColorButton {
    private final SideDataPacketCreator packetCreator;
    private final Supplier<DataType> dataTypeSupplier;
    private final TileEntityMekanism tile;
    private final RelativeSide slotPos;
    private final ItemStack otherBlockItem;
    private final boolean displayDataType;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;

    public SideDataButton(IGuiWrapper gui, int x, int y, RelativeSide slotPos, Supplier<DataType> dataTypeSupplier, Supplier<EnumColor> colorSupplier, TileEntityMekanism tile, SideDataPacketCreator packetCreator, boolean displayDataType) {
        super(gui, x, y, 22, () -> {
            DataType dataType = (DataType)dataTypeSupplier.get();
            return dataType == null ? null : (EnumColor)colorSupplier.get();
        }, (GuiElement element, double mouseX, double mouseY) -> {
            SideDataButton button = (SideDataButton)element;
            return PacketUtils.sendToServer(button.packetCreator.create(button.tile.getBlockPos(), MekClickType.left(Screen.hasShiftDown()), button.slotPos));
        }, (GuiElement element, double mouseX, double mouseY) -> {
            SideDataButton button = (SideDataButton)element;
            return PacketUtils.sendToServer(button.packetCreator.create(button.tile.getBlockPos(), MekClickType.RIGHT, button.slotPos));
        });
        this.dataTypeSupplier = dataTypeSupplier;
        this.displayDataType = displayDataType;
        this.packetCreator = packetCreator;
        this.tile = tile;
        this.slotPos = slotPos;
        Level tileWorld = tile.getLevel();
        if (tileWorld != null) {
            Direction globalSide = slotPos.getDirection(tile.getDirection());
            BlockPos otherBlockPos = tile.getBlockPos().relative(globalSide);
            BlockState blockOnSide = tileWorld.getBlockState(otherBlockPos);
            this.otherBlockItem = !blockOnSide.isAir() ? blockOnSide.getCloneItemStack((HitResult)new BlockHitResult(otherBlockPos.getCenter().relative(globalSide.getOpposite(), 0.5), globalSide.getOpposite(), otherBlockPos, false), (LevelReader)tileWorld, otherBlockPos, (Player)Minecraft.getInstance().player) : ItemStack.EMPTY;
        } else {
            this.otherBlockItem = ItemStack.EMPTY;
        }
    }

    public DataType getDataType() {
        return this.dataTypeSupplier.get();
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.otherBlockItem.isEmpty()) {
            GuiUtils.renderItem(guiGraphics, this.otherBlockItem, this.getRelativeX() + 3, this.getRelativeY() + 3, 1.0f, this.font(), null, true);
        }
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        DataType dataType = this.getDataType();
        if (dataType != null) {
            ArrayList<Component> tooltipLines = new ArrayList<Component>(3);
            tooltipLines.add((Component)TextComponentUtil.build(this.slotPos));
            if (this.displayDataType) {
                tooltipLines.add((Component)TextComponentUtil.build(dataType.getColor(), dataType));
            } else {
                EnumColor color = this.getColor();
                tooltipLines.add((Component)(color == null ? MekanismLang.NONE.translate() : color.getColoredName()));
            }
            if (!this.otherBlockItem.isEmpty()) {
                tooltipLines.add(this.otherBlockItem.getHoverName());
            }
            if (!tooltipLines.equals(this.lastInfo)) {
                this.lastInfo = tooltipLines;
                this.lastTooltip = TooltipUtils.create(tooltipLines);
            }
        } else {
            this.lastTooltip = null;
            this.lastInfo = Collections.emptyList();
        }
        this.setTooltip(this.lastTooltip);
    }

    @FunctionalInterface
    public static interface SideDataPacketCreator {
        public IMekanismPacket create(BlockPos var1, MekClickType var2, RelativeSide var3);
    }
}

