/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.content.network.distribution.FluidHandlerTarget;
import mekanism.common.content.network.distribution.FluidTransmitterSaveTarget;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.lib.distribution.Target;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidNetwork
extends DynamicBufferedNetwork<IFluidHandler, FluidNetwork, FluidStack, MechanicalPipe>
implements IMekanismFluidHandler {
    private final List<IExtendedFluidTank> fluidTanks;
    public final VariableCapacityFluidTank fluidTank;
    @NotNull
    public FluidStack lastFluid = FluidStack.EMPTY;
    private int prevTransferAmount;
    private int intCapacity;

    public FluidNetwork(UUID networkID) {
        super(networkID);
        this.fluidTank = VariableCapacityFluidTank.create(this::getCapacityAsInt, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), (IContentsListener)this);
        this.fluidTanks = Collections.singletonList(this.fluidTank);
    }

    public FluidNetwork(Collection<FluidNetwork> networks) {
        this(UUID.randomUUID());
        this.adoptAllAndRegister(networks);
    }

    @Override
    protected void forceScaleUpdate() {
        this.currentScale = !this.fluidTank.isEmpty() && this.fluidTank.getCapacity() > 0 ? Math.min(1.0f, (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity()) : 0.0f;
    }

    @Override
    public List<MechanicalPipe> adoptTransmittersAndAcceptorsFrom(FluidNetwork net) {
        float oldScale = this.currentScale;
        long oldCapacity = this.getCapacity();
        List<MechanicalPipe> transmittersToUpdate = super.adoptTransmittersAndAcceptorsFrom(net);
        long capacity = this.getCapacity();
        this.currentScale = Math.min(1.0f, capacity == 0L ? 0.0f : (this.currentScale * (float)oldCapacity + net.currentScale * (float)net.capacity) / (float)capacity);
        if (this.isRemote()) {
            if (this.fluidTank.isEmpty() && !net.fluidTank.isEmpty()) {
                this.fluidTank.setStack(net.getBuffer());
                net.fluidTank.setEmpty();
            }
        } else {
            if (!net.fluidTank.isEmpty()) {
                if (this.fluidTank.isEmpty()) {
                    this.fluidTank.setStack(net.getBuffer());
                } else if (this.fluidTank.isFluidEqual(net.fluidTank.getFluid())) {
                    int amount = net.fluidTank.getFluidAmount();
                    MekanismUtils.logMismatchedStackSize(this.fluidTank.growStack(amount, Action.EXECUTE), amount);
                } else {
                    Mekanism.logger.error("Incompatible fluid networks merged.");
                }
                net.fluidTank.setEmpty();
            }
            if (oldScale != this.currentScale) {
                this.needsUpdate = true;
            }
        }
        return transmittersToUpdate;
    }

    @Override
    @NotNull
    public FluidStack getBuffer() {
        return this.fluidTank.getFluid().copy();
    }

    @Override
    public void absorbBuffer(MechanicalPipe transmitter) {
        FluidStack fluid = transmitter.releaseShare();
        if (!fluid.isEmpty()) {
            if (this.fluidTank.isEmpty()) {
                this.fluidTank.setStack(fluid.copy());
            } else if (this.fluidTank.isFluidEqual(fluid)) {
                int amount = fluid.getAmount();
                MekanismUtils.logMismatchedStackSize(this.fluidTank.growStack(amount, Action.EXECUTE), amount);
            }
        }
    }

    @Override
    public void clampBuffer() {
        if (!this.fluidTank.isEmpty()) {
            int capacity = this.getCapacityAsInt();
            if (this.fluidTank.getFluidAmount() > capacity) {
                MekanismUtils.logMismatchedStackSize(this.fluidTank.setStackSize(capacity, Action.EXECUTE), capacity);
            }
        }
    }

    @Override
    protected synchronized void updateCapacity(MechanicalPipe transmitter) {
        super.updateCapacity(transmitter);
        this.intCapacity = MathUtils.clampToInt(this.getCapacity());
    }

    @Override
    public synchronized void updateCapacity() {
        super.updateCapacity();
        this.intCapacity = MathUtils.clampToInt(this.getCapacity());
    }

    public int getCapacityAsInt() {
        return this.intCapacity;
    }

    @Override
    protected void updateSaveShares(@Nullable MechanicalPipe triggerTransmitter) {
        super.updateSaveShares(triggerTransmitter);
        if (!this.isEmpty()) {
            FluidStack fluidType = this.fluidTank.getFluid();
            FluidTransmitterSaveTarget saveTarget = new FluidTransmitterSaveTarget(this.getTransmitters());
            EmitUtils.sendToAcceptors(saveTarget, fluidType.getAmount(), fluidType);
            saveTarget.saveShare();
        }
    }

    private int tickEmit(@NotNull FluidStack fluidToSend) {
        Collection acceptorValues = this.acceptorCache.getAcceptorValues();
        Target target = null;
        for (Map acceptors : acceptorValues) {
            for (IFluidHandler acceptor : acceptors.values()) {
                if (!FluidUtils.canFill(acceptor, fluidToSend)) continue;
                if (target == null) {
                    target = new FluidHandlerTarget(acceptorValues.size() * 2);
                }
                target.addHandler(acceptor);
            }
        }
        return EmitUtils.sendToAcceptors(target, fluidToSend.getAmount(), fluidToSend);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.needsUpdate) {
            NeoForge.EVENT_BUS.post((Event)new FluidTransferEvent(this, this.lastFluid));
            this.needsUpdate = false;
        }
        if (this.fluidTank.isEmpty()) {
            this.prevTransferAmount = 0;
        } else {
            this.prevTransferAmount = this.tickEmit(this.fluidTank.getFluid());
            MekanismUtils.logMismatchedStackSize(this.fluidTank.shrinkStack(this.prevTransferAmount, Action.EXECUTE), this.prevTransferAmount);
        }
    }

    @Override
    protected float computeContentScale() {
        float scale = (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
        float ret = Math.max(this.currentScale, scale);
        if (this.prevTransferAmount > 0 && ret < 1.0f) {
            ret = Math.min(1.0f, ret + 0.02f);
        } else if (this.prevTransferAmount <= 0 && ret > 0.0f) {
            ret = Math.max(scale, ret - 0.02f);
        }
        return ret;
    }

    public int getPrevTransferAmount() {
        return this.prevTransferAmount;
    }

    public String toString() {
        return "[FluidNetwork] " + this.transmittersSize() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    public Component getNeededInfo() {
        return MekanismLang.FLUID_NETWORK_NEEDED.translate(Float.valueOf((float)this.fluidTank.getNeeded() / 1000.0f));
    }

    @Override
    public Component getStoredInfo() {
        if (this.fluidTank.isEmpty()) {
            return MekanismLang.NONE.translate();
        }
        return MekanismLang.NETWORK_MB_STORED.translate(this.fluidTank.getFluid(), this.fluidTank.getFluidAmount());
    }

    @Override
    public Component getFlowInfo() {
        return MekanismLang.NETWORK_MB_PER_TICK.translate(this.prevTransferAmount);
    }

    @Override
    public boolean isCompatibleWith(FluidNetwork other) {
        return super.isCompatibleWith(other) && (this.fluidTank.isEmpty() || other.fluidTank.isEmpty() || this.fluidTank.isFluidEqual(other.fluidTank.getFluid()));
    }

    @Override
    @NotNull
    public Component getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.FLUID_NETWORK, this.transmittersSize(), this.getAcceptorCount());
    }

    @Override
    @NotNull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty();
        FluidStack type = this.fluidTank.getFluid();
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.lastFluid, (FluidStack)type)) {
            if (!type.isEmpty()) {
                this.lastFluid = type.copyWithAmount(1);
            }
            this.needsUpdate = true;
        }
    }

    public void setLastFluid(@NotNull FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.fluidTank.setEmpty();
        } else {
            this.lastFluid = fluid;
            this.fluidTank.setStack(fluid.copyWithAmount(1));
        }
    }

    public static class FluidTransferEvent
    extends DynamicBufferedNetwork.TransferEvent<FluidNetwork> {
        public final FluidStack fluidType;

        public FluidTransferEvent(FluidNetwork network, @NotNull FluidStack type) {
            super(network);
            this.fluidType = type;
        }
    }
}

