/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.tab.GuiWarningTab;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.IWarningTracker;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.element.GuiFusionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiFusionReactorController
extends GuiMekanismTile<TileEntityFusionReactorController, MekanismTileContainer<TileEntityFusionReactorController>> {
    public GuiFusionReactorController(MekanismTileContainer<TileEntityFusionReactorController> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.imageWidth += 10;
        this.inventoryLabelX += 5;
        this.titleLabelY = 5;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        if (((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).isFormed()) {
            this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> {
                FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
                return List.of(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((IEnergyContainer)multiblock.energyContainer)}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((long)multiblock.getPassiveGeneration(false, true))}));
            }));
            this.addRenderableWidget((GuiElement)new GuiHeatTab((IGuiWrapper)this, () -> {
                FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
                Component transfer = MekanismUtils.getTemperatureDisplay((double)multiblock.lastTransferLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
                Component environment = MekanismUtils.getTemperatureDisplay((double)multiblock.lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
                return List.of(MekanismLang.TRANSFERRED_RATE.translate(new Object[]{transfer}), MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
            }));
            this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.HEAT));
            this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.FUEL));
            this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.STAT));
        }
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.renderInventoryText(guiGraphics);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MULTIBLOCK_FORMED.translate(), 0, 16, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 13, false);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    protected void addWarningTab(IWarningTracker warningTracker) {
        this.addRenderableWidget((GuiElement)new GuiWarningTab((IGuiWrapper)this, warningTracker, false));
    }
}

