/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.MatchesIterator;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.TermMatchesIterator;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefIterator;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class DisjunctionMatchesIterator
implements MatchesIterator {
    private final PriorityQueue<MatchesIterator> queue;
    private boolean started = false;

    static MatchesIterator fromTerms(LeafReaderContext context, int doc, Query query, String field, List<Term> terms) throws IOException {
        Objects.requireNonNull(field);
        for (Term term : terms) {
            if (Objects.equals(field, term.field())) continue;
            throw new IllegalArgumentException("Tried to generate iterator from terms in multiple fields: expected [" + field + "] but got [" + term.field() + "]");
        }
        return DisjunctionMatchesIterator.fromTermsEnum(context, doc, query, field, DisjunctionMatchesIterator.asBytesRefIterator(terms));
    }

    private static BytesRefIterator asBytesRefIterator(final List<Term> terms) {
        return new BytesRefIterator(){
            int i = 0;

            @Override
            public BytesRef next() {
                if (this.i >= terms.size()) {
                    return null;
                }
                return ((Term)terms.get(this.i++)).bytes();
            }
        };
    }

    static MatchesIterator fromTermsEnum(LeafReaderContext context, int doc, Query query, String field, BytesRefIterator terms) throws IOException {
        Objects.requireNonNull(field);
        Terms t = Terms.getTerms(context.reader(), field);
        TermsEnum te = t.iterator();
        PostingsEnum reuse = null;
        BytesRef term = terms.next();
        while (term != null) {
            if (te.seekExact(term)) {
                PostingsEnum pe = te.postings(reuse, 56);
                if (pe.advance(doc) == doc) {
                    return new TermsEnumDisjunctionMatchesIterator(new TermMatchesIterator(query, pe), terms, te, doc, query);
                }
                reuse = pe;
            }
            term = terms.next();
        }
        return null;
    }

    static MatchesIterator fromSubIterators(List<MatchesIterator> mis) throws IOException {
        if (mis.size() == 0) {
            return null;
        }
        if (mis.size() == 1) {
            return mis.get(0);
        }
        return new DisjunctionMatchesIterator(mis);
    }

    private DisjunctionMatchesIterator(List<MatchesIterator> matches) throws IOException {
        this.queue = new PriorityQueue<MatchesIterator>(this, matches.size()){

            @Override
            protected boolean lessThan(MatchesIterator a, MatchesIterator b) {
                if (a.startPosition() == -1 && b.startPosition() == -1) {
                    try {
                        return a.startOffset() < b.startOffset() || a.startOffset() == b.startOffset() && a.endOffset() < b.endOffset() || a.startOffset() == b.startOffset() && a.endOffset() == b.endOffset();
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Failed to retrieve term offset", e);
                    }
                }
                return a.startPosition() < b.startPosition() || a.startPosition() == b.startPosition() && a.endPosition() < b.endPosition() || a.startPosition() == b.startPosition() && a.endPosition() == b.endPosition();
            }
        };
        for (MatchesIterator mi : matches) {
            if (!mi.next()) continue;
            this.queue.add(mi);
        }
    }

    @Override
    public boolean next() throws IOException {
        if (!this.started) {
            this.started = true;
            return this.queue.size() > 0;
        }
        if (!this.queue.top().next()) {
            this.queue.pop();
        }
        if (this.queue.size() > 0) {
            this.queue.updateTop();
            return true;
        }
        return false;
    }

    @Override
    public int startPosition() {
        return this.queue.top().startPosition();
    }

    @Override
    public int endPosition() {
        return this.queue.top().endPosition();
    }

    @Override
    public int startOffset() throws IOException {
        return this.queue.top().startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.queue.top().endOffset();
    }

    @Override
    public MatchesIterator getSubMatches() throws IOException {
        return this.queue.top().getSubMatches();
    }

    @Override
    public Query getQuery() {
        return this.queue.top().getQuery();
    }

    private static class TermsEnumDisjunctionMatchesIterator
    implements MatchesIterator {
        private final MatchesIterator first;
        private final BytesRefIterator terms;
        private final TermsEnum te;
        private final int doc;
        private final Query query;
        private MatchesIterator it = null;

        TermsEnumDisjunctionMatchesIterator(MatchesIterator first, BytesRefIterator terms, TermsEnum te, int doc, Query query) {
            this.first = first;
            this.terms = terms;
            this.te = te;
            this.doc = doc;
            this.query = query;
        }

        private void init() throws IOException {
            ArrayList<MatchesIterator> mis = new ArrayList<MatchesIterator>();
            mis.add(this.first);
            PostingsEnum reuse = null;
            BytesRef term = this.terms.next();
            while (term != null) {
                if (this.te.seekExact(term)) {
                    PostingsEnum pe = this.te.postings(reuse, 56);
                    if (pe.advance(this.doc) == this.doc) {
                        mis.add(new TermMatchesIterator(this.query, pe));
                        reuse = null;
                    } else {
                        reuse = pe;
                    }
                }
                term = this.terms.next();
            }
            this.it = DisjunctionMatchesIterator.fromSubIterators(mis);
        }

        @Override
        public boolean next() throws IOException {
            if (this.it == null) {
                this.init();
            }
            assert (this.it != null);
            return this.it.next();
        }

        @Override
        public int startPosition() {
            return this.it.startPosition();
        }

        @Override
        public int endPosition() {
            return this.it.endPosition();
        }

        @Override
        public int startOffset() throws IOException {
            return this.it.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.it.endOffset();
        }

        @Override
        public MatchesIterator getSubMatches() throws IOException {
            return this.it.getSubMatches();
        }

        @Override
        public Query getQuery() {
            return this.it.getQuery();
        }
    }
}

