/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.matchhighlight;

import guideme.internal.shaded.lucene.search.matchhighlight.BreakIteratorShrinkingAdjuster;
import guideme.internal.shaded.lucene.search.matchhighlight.MatchHighlighter;
import guideme.internal.shaded.lucene.search.matchhighlight.OffsetRange;
import guideme.internal.shaded.lucene.search.matchhighlight.Passage;
import guideme.internal.shaded.lucene.search.matchhighlight.PassageFormatter;
import guideme.internal.shaded.lucene.search.matchhighlight.PassageSelector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public final class FieldValueHighlighters {
    private FieldValueHighlighters() {
    }

    public static MatchHighlighter.FieldValueHighlighter maxLeadingCharacters(final int maxLeadingCharacters, String ellipsis, final Set<String> fields) {
        final PassageSelector passageSelector = FieldValueHighlighters.defaultPassageSelector();
        final PassageFormatter passageFormatter = new PassageFormatter(ellipsis, "", "");
        return new AbstractFieldValueHighlighter((field, hasMatches) -> fields.contains(field)){

            @Override
            public List<String> format(String field, List<String> values, String contiguousValue, List<OffsetRange> valueRanges, List<MatchHighlighter.QueryOffsetRange> matchOffsets) {
                List<Passage> bestPassages = passageSelector.pickBest(contiguousValue, Collections.emptyList(), maxLeadingCharacters, 1, valueRanges);
                return passageFormatter.format(contiguousValue, bestPassages, valueRanges);
            }

            @Override
            public Collection<String> alwaysFetchedFields() {
                return fields;
            }
        };
    }

    public static PassageSelector defaultPassageSelector() {
        return new PassageSelector(PassageSelector.DEFAULT_SCORER, new BreakIteratorShrinkingAdjuster());
    }

    public static MatchHighlighter.FieldValueHighlighter highlighted(final int maxPassageWindow, final int maxPassages, final PassageFormatter passageFormatter, Predicate<String> matchFields) {
        final PassageSelector passageSelector = FieldValueHighlighters.defaultPassageSelector();
        return new AbstractFieldValueHighlighter((field, hasMatches) -> matchFields.test((String)field) && hasMatches != false){

            @Override
            public List<String> format(String field, List<String> values, String contiguousValue, List<OffsetRange> valueRanges, List<MatchHighlighter.QueryOffsetRange> matchOffsets) {
                assert (matchOffsets != null);
                List<Passage> bestPassages = passageSelector.pickBest(contiguousValue, matchOffsets, maxPassageWindow, maxPassages, valueRanges);
                return passageFormatter.format(contiguousValue, bestPassages, valueRanges);
            }
        };
    }

    public static MatchHighlighter.FieldValueHighlighter verbatimValue(String field, String ... moreFields) {
        final HashSet<String> matchFields = new HashSet<String>(Arrays.asList(moreFields));
        matchFields.add(field);
        return new AbstractFieldValueHighlighter((fld, hasMatches) -> matchFields.contains(fld)){

            @Override
            public Collection<String> alwaysFetchedFields() {
                return matchFields;
            }

            @Override
            public List<String> format(String field, List<String> values, String contiguousValue, List<OffsetRange> valueRanges, List<MatchHighlighter.QueryOffsetRange> matchOffsets) {
                return values;
            }
        };
    }

    public static MatchHighlighter.FieldValueHighlighter skipRemaining() {
        return new AbstractFieldValueHighlighter((field, hasMatches) -> true){

            @Override
            public List<String> format(String field, List<String> values, String contiguousValue, List<OffsetRange> valueRanges, List<MatchHighlighter.QueryOffsetRange> matchOffsets) {
                return null;
            }
        };
    }

    private static abstract class AbstractFieldValueHighlighter
    implements MatchHighlighter.FieldValueHighlighter {
        private final BiPredicate<String, Boolean> testPredicate;

        protected AbstractFieldValueHighlighter(BiPredicate<String, Boolean> testPredicate) {
            this.testPredicate = testPredicate;
        }

        @Override
        public final boolean isApplicable(String field, boolean hasMatches) {
            return this.testPredicate.test(field, hasMatches);
        }
    }
}

