/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.commands;

import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class Delete {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"UUID", (ArgumentType)StringArgumentType.string()).executes(cs -> Delete.delete((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"UUID"))))).then(Commands.argument((String)"CONFIRMATION", (ArgumentType)StringArgumentType.string()).executes(cs -> Delete.delete((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"CONFIRMATION"))));
    }

    public static int delete(CommandContext<CommandSourceStack> ctx, String stringUUID) throws CommandSyntaxException {
        UUID uuid;
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        BackpackManager backpacks = BackpackManager.get();
        if (stringUUID.length() == 8) {
            BackpackUtils.getConfirmation(stringUUID).ifPresent(confirmation -> {
                if (player.getUUID().equals(confirmation.player())) {
                    backpacks.removeBackpack(confirmation.backpack());
                    BackpackUtils.removeConfirmation(stringUUID);
                    ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"simplybackpacks.delete.finished", (Object[])new Object[]{confirmation.backpack()}), false);
                }
            });
        }
        try {
            uuid = UUID.fromString(stringUUID);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        Optional<BackpackData> data = backpacks.getBackpack(uuid);
        data.ifPresentOrElse(backpack -> {
            String code = BackpackUtils.generateCode(player.level().random);
            BackpackUtils.addConfirmation(code, player.getUUID(), backpack.getUuid());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"simplybackpacks.delete.confirmation", (Object[])new Object[]{Component.literal((String)code).withStyle(ChatFormatting.GOLD)}), false);
        }, () -> ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"simplybackpacks.invaliduuid")));
        return 0;
    }
}

