/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.commands;

import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class List {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(cs -> cs.hasPermission(1))).executes(List::list)).then(Commands.literal((String)"firstOpenedBy").then(Commands.argument((String)"PlayerName", (ArgumentType)StringArgumentType.string()).suggests((cs, builder) -> SharedSuggestionProvider.suggest(List.getPlayerSuggestions((CommandContext<CommandSourceStack>)cs), (SuggestionsBuilder)builder)).executes(cs -> List.first((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"PlayerName")))))).then(Commands.literal((String)"lastOpenedBy").then(Commands.argument((String)"PlayerName", (ArgumentType)StringArgumentType.string()).suggests((cs, builder) -> SharedSuggestionProvider.suggest(List.getPlayerSuggestions((CommandContext<CommandSourceStack>)cs), (SuggestionsBuilder)builder)).executes(cs -> List.last((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"PlayerName")))));
    }

    public static Set<String> getPlayerSuggestions(CommandContext<CommandSourceStack> commandSource) {
        HashSet<String> list = new HashSet<String>();
        ((CommandSourceStack)commandSource.getSource()).getServer().getPlayerList().getPlayers().forEach(serverPlayerEntity -> list.add(serverPlayerEntity.getName().getString()));
        return list;
    }

    public static void sendBackpack(Player player, BackpackData backpack) {
        player.sendSystemMessage((Component)Component.literal((String)"===========================").withStyle(ChatFormatting.DARK_GRAY));
        player.sendSystemMessage((Component)Component.literal((String)(backpack.getUuid().toString().substring(0, 8) + "...\nFirst: " + backpack.meta.getFirstAccessedPlayer() + "\n" + SDF.format(new Date(backpack.meta.getFirstAccessedTime())) + "\nLast: " + backpack.meta.getLastAccessedPlayer() + "\n" + SDF.format(new Date(backpack.meta.getLastAccessedTime())))));
        MutableComponent open_link = Component.literal((String)"Open");
        open_link.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sb open " + backpack.getUuid().toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open Backpack"))).withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)));
        MutableComponent recover_link = Component.literal((String)"Recover");
        recover_link.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sb recover " + backpack.getUuid().toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Recover Backpack"))).withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)));
        MutableComponent delete_link = Component.literal((String)"Delete");
        delete_link.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sb delete " + backpack.getUuid().toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Delete Backpack"))).withColor(ChatFormatting.RED).withUnderlined(Boolean.valueOf(true)));
        player.sendSystemMessage((Component)Component.literal((String)"[").append((Component)open_link).append("] - [").append((Component)recover_link).append("] - [").append((Component)delete_link).append("]"));
    }

    public static int list(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BackpackManager backpacks = BackpackManager.get();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        if (backpacks.getMap().size() == 0) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"[ ]"), false);
            return 0;
        }
        backpacks.getMap().forEach((uuid, backpack) -> List.sendBackpack((Player)player, backpack));
        return 0;
    }

    public static int first(CommandContext<CommandSourceStack> ctx, String playerName) throws CommandSyntaxException {
        BackpackManager backpacks = BackpackManager.get();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        if (backpacks.getMap().size() == 0) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"[ ]"), false);
            return 0;
        }
        backpacks.getMap().forEach((uuid, backpack) -> {
            if (backpack.meta.getFirstAccessedPlayer().equalsIgnoreCase(playerName)) {
                List.sendBackpack((Player)player, backpack);
            }
        });
        return 0;
    }

    public static int last(CommandContext<CommandSourceStack> ctx, String playerName) throws CommandSyntaxException {
        BackpackManager backpacks = BackpackManager.get();
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        if (backpacks.getMap().size() == 0) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"[ ]"), false);
            return 0;
        }
        backpacks.getMap().forEach((uuid, backpack) -> {
            if (backpack.meta.getLastAccessedPlayer().equalsIgnoreCase(playerName)) {
                List.sendBackpack((Player)player, backpack);
            }
        });
        return 0;
    }
}

