/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.commands;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class Recover {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"recover").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"UUID", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(BackpackUtils.getUUIDSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(cs -> Recover.recover((CommandContext<CommandSourceStack>)cs, StringArgumentType.getString((CommandContext)cs, (String)"UUID"))));
    }

    public static int recover(CommandContext<CommandSourceStack> ctx, String stringUUID) throws CommandSyntaxException {
        UUID uuid;
        try {
            uuid = UUID.fromString(stringUUID);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        BackpackManager backpacks = BackpackManager.get();
        if (backpacks.getMap().containsKey(uuid)) {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Optional<BackpackData> data = backpacks.getBackpack(uuid);
            data.ifPresent(backpack -> {
                ItemStack stack = new ItemStack((ItemLike)backpack.getTier().item.get());
                stack.set(SimplyBackpacks.BACKPACK_UUID, (Object)backpack.getUuid());
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            });
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"simplybackpacks.invaliduuid"));
        }
        return 0;
    }
}

